package cl.jtv;
/*
 * Submaquina.java
 *
 * Created on 3 de octubre de 2002, 03:33 AM
 */

/**
 *
 * @author  Administrador
 * @version 
 */
import java.util.*;
import java.awt.*;
import java.awt.geom.Rectangle2D;
import java.awt.font.FontRenderContext;
import java.lang.*;


public class Submaquina extends Maquina {
    

protected String nombreLargo;
protected String nombreCorto;
protected String descripcion;

//SharedInteger numOfNodes;
Maquina submaquina;
Vector machineComponents;
NodeTreeTrace rootTreeTrace;
//Cinta[] arrayOfTapes;
Hashtable variables;
Hashtable parametros;
private boolean not;
private boolean monocinta;

    /** Creates new Submaquina */
    public Submaquina(int x,int y,int c,Maquina prev,Maquina prox) {
        
        super(x,y,c,prev,prox);
        this.setIconValue(JTV.MyRenderer.ICONO_SUBMAQUINA);
        setNombre("M");
        variables = new Hashtable();
        parametros = new Hashtable();
        machineComponents=null;
    }
    
    /** Getter for property descripcion.
     * @return Value of property descripcion.
     */
    public java.lang.String getDescripcion() {
        return descripcion;
    }    
    
    /** Setter for property descripcion.
     * @param descripcion New value of property descripcion.
     */
    public void setDescripcion(java.lang.String descripcion) {
        this.descripcion = descripcion;
    }
    
    /** Getter for property nombreCorto.
     * @return Value of property nombreCorto.
     */
    public java.lang.String getNombreCorto() {
        if(this.machineComponents==null)   
            return nombreCorto;
        else
            return ((Vector2)this.machineComponents).getNombreCorto();
    }
    
    /** Setter for property nombreCorto.
     * @param nombreCorto New value of property nombreCorto.
     */
    public void setNombreCorto(java.lang.String nombreCorto) {
        nombreCorto = nombreCorto;     
    }
    
    /** Getter for property nombreLargo.
     * @return Value of property nombreLargo.
     */
    public java.lang.String getNombreLargo() {
        if(this.machineComponents==null)   
            return nombreLargo;
        else
            return ((Vector2)this.machineComponents).getNombreLargo();
    }
    
    /** Setter for property nombreLargo.
     * @param nombreLargo New value of property nombreLargo.
     */
    public void setNombreLargo(java.lang.String nombreLargo) {
        this.nombreLargo = nombreLargo;
    }
    
    /*public boolean accion(Cinta[] _arrayOfTapes,DiccionarioMetavalores dicMetavalores){
        
        NodeTreeTrace auxNode = this.rootTreeTrace;
        
        if(this.rootTreeTrace==null){
            System.out.println("rootTreeTrace es NULO");
            return false;
        }
        
        for(int i=1;i<=this.rootTreeTrace.getChildCount();i++){
            int iconValue = ((NodeTreeTrace)auxNode).getIconValue();
            if(!auxNode.isRoot() && iconValue != JTV.MyRenderer.ICONO_STOP && iconValue != JTV.MyRenderer.ICONO_WARNING && iconValue != JTV.MyRenderer.ICONO_EXPANDIR && iconValue != JTV.MyRenderer.ICONO_RECHAZA)
    
                if(!(auxNode.getMachine() instanceof Submaquina))
                    auxNode.getMachine().accion(_arrayOfTapes,rootTreeTrace.dicMetavalores);
                else
                    auxNode.contextoSubmaquina.accion(_arrayOfTapes);
                auxNode = (NodeTreeTrace)auxNode.getNextNode();
        }
        return true;
   } */
    
    public void dibujar(Graphics g){


    if(Maquina.selectedMachine!=null && this==Maquina.selectedMachine)
        g.setColor(Color.magenta);
    else if(JTV.searchedMachine!=null && this==JTV.searchedMachine)
        g.setColor(Color.pink);
    else if(Maquina.playMachine!=null && this==Maquina.playMachine)
        g.setColor(Color.red);
    else
        g.setColor(Color.black);
   
    g.setFont(Maquina.FONT_TRI25);
    
    if(!Maquina.oldNotation && getNombre().equals("L"))
        LHD.dibujar(g,x0,y0);
    else if(!Maquina.oldNotation && getNombre().equals("R"))
        RHD.dibujar(g,x0,y0);
    else
        g.drawString(getNombre(),x0,y0);
    
    if(this.isInicial()) g.drawString(Maquina.SIMBOLO_INICIAL,x0-(int)Maquina.RECT_INICIAL.getWidth(),y0);
    
    /*if(isMonocinta()){
        g.setFont(Maquina.FONT_TRP13);
        g.drawString("(" + (this.getIndiceCinta()+1) + ")",x0+Maquina.delta_x,y0-Maquina.delta_y);
    }*/
    
    g.setFont(Maquina.FONT_AP8);
    
    Rectangle2D rect1 = Maquina.FONT_TRI25.getStringBounds(getNombre(),new FontRenderContext(Maquina.FONT_TRI25.getTransform(),true,true));
    if(getNombreCorto()!=null){
        Rectangle2D rect2 = Maquina.FONT_AP8.getStringBounds(getNombreCorto(),new FontRenderContext(Maquina.FONT_AP8.getTransform(),true,true));
        g.drawString(getNombreCorto(),(int)(x0-Math.abs(rect1.getX()-rect2.getX())/2),(int)(y0-rect2.getY()+2));
    }
    
    
    Set en = parametros.keySet();
    java.util.List list = new java.util.ArrayList(en);
    java.util.Collections.sort(list);      
    java.util.Iterator iter = list.iterator();
    
    String stringParametros="";
    try{
    while(iter.hasNext()) 
        stringParametros+=(((Parametro)parametros.get(iter.next())).getNombre()+",");
    }
    catch(Exception ex){
        System.out.println("Excepcion");
    }
    if(stringParametros.length()>0) stringParametros = stringParametros.substring(0,stringParametros.length()-1);
    Rectangle2D rect3 = Maquina.FONT_TRI14.getStringBounds(stringParametros,new FontRenderContext(Maquina.FONT_TRP13.getTransform(),true,true));
    g.setFont(Maquina.FONT_TRI14);
    if(this.isNot()) g.drawLine(x0+(int)rect1.getWidth(),y0-2,x0+(int)rect1.getWidth()+(int)rect3.getWidth(),y0-2);
    //g.drawString(stringParametros,x0+(int)rect1.getWidth(),(int)(y0-rect3.getY()-4));
    g.drawString(stringParametros,x0+(int)rect1.getWidth()+2,y0+(int)rect3.getHeight()-7);
    
    if(Maquina.displayIndex){
        g.setFont(Maquina.FONT_TRP13);
        g.drawString("(" + (this.getIndiceCinta()+1) + ")",x0+(monocinta?1:2)*Maquina.delta_x,y0-Maquina.delta_y);
    }
    super.dibujar(g);

  }
   
  /** Getter for property not.
   * @return Value of property not.
   */
  public boolean isNot() {
      return not;
  }  

  /** Setter for property not.
   * @param not New value of property not.
   */
  public void setNot(boolean not) {
      this.not = not;
  }
  
  /** Getter for property multicinta.
   * @return Value of property multicinta.
   */
  public boolean isMonocinta() {
      return monocinta;
  }
  
  /** Setter for property multicinta.
   * @param multicinta New value of property multicinta.
   */
  public void setMonocinta(boolean monocinta) {
      this.monocinta = monocinta;
  }
  
  public void refreshParametros(boolean move){
      
      if(monocinta) return;
      //if(machineComponents==null) return;  //Temporal
      Vector vectorParametros = ((Vector2)machineComponents).getParametros();
      Enumeration en = vectorParametros.elements();
      //parametros.clear(); //Transitorio
      while(en.hasMoreElements()){
            String parametro = (String)en.nextElement();
            if(!parametros.containsKey(parametro)){
                parametros.put(parametro,new Parametro(parametro));
                if(move && this.proxima!=null && !(this.proxima instanceof EnlaceCompuesto)) this.proxima.moveForward3(13);
            }
      }
      
      en = null;
      en = ((Hashtable)parametros.clone()).keys();
      
      while(en.hasMoreElements()){
            String parametro = (String)en.nextElement();
            if(!vectorParametros.contains(parametro)){
                parametros.remove(parametro);
                if(move && this.proxima!=null && !(this.proxima instanceof EnlaceCompuesto)) this.proxima.moveForward3(-13);
            }
      }
      
  }
  
   public int showDialog(int numOfTapes,boolean addComando){
        
       if(this.getNombre().equals("S")) return DialogParametros.RET_CANCEL;
       
        DialogParametros dv = new DialogParametros(new javax.swing.JFrame (), true,this,addComando);
        //dv.setSize(400,400);
        dv.setVisible(true);
        
        return dv.getReturnStatus();
    }
    
    
    public int getDelta(){
        
        if(this.parametros.size()==0)
            return 20;
        else
            return 20+parametros.size()*13;
        
    }
  
    public String getXML() {
        
      String xml = "";
      String tail = "/>\n\n";
      String tag = "";
      boolean param = false;
      if(nombre.equals("M")){
          xml+="<submaquina\n";
          tag = "</submaquina>\n";
          param = true;
      }
      else if(nombre.equals("L")&&!this.not){
          xml+="<buscadora-L\n";
          tag = "</buscadora-L>\n";
          param = true;
      }
      else if(nombre.equals("L")&&this.not){
          xml+="<buscadora-L-NOT\n";
          tag = "</buscadora-L-NOT>\n";
          param = true;
      }
      else if(nombre.equals("R")&&!this.not){
          xml+="<buscadora-R\n";
          tag = "</buscadora-R>\n";
          param = true;
      }
      else if(nombre.equals("R")&&this.not){
          xml+="<buscadora-R-NOT\n";
          tag = "</buscadora-R-NOT>\n";
          param = true;
      }
      else if(nombre.equals("S")&&this.parametros.containsKey("L")){
          xml+="<SL\n";
      }
      else if(nombre.equals("S")&&this.parametros.containsKey("R")){
          xml+="<SR\n";
      }
      
      /*if(nombre.equals("S")) 
          System.out.println("nombre es igual a S");
      else
          System.out.println("nombre NO es igual a S");
      
      if(this.parametros.containsKey("L"))
          System.out.println("contiene parmetro L");
      else if(this.parametros.containsKey("R"))
          System.out.println("contiene parmetro R");
      else
          System.out.println("no contiene ni L ni R");*/
      
      try{
      if(param){
          Enumeration en = this.parametros.keys();
          tail = ">\n";
          while(en.hasMoreElements()){
               String nombreParametro = (String)en.nextElement();
               Parametro parametro = (Parametro)this.parametros.get(nombreParametro);
               if(parametro.isSet())
                   tail+="   <parametro nombre=\""+nombreParametro+"\" valor=\""+parametro.getNombre()+"\"/>\n";
               else
                   tail+="   <parametro nombre=\""+nombreParametro+"\" valor=\""+"INDEFINIDO"+"\"/>\n";         
          }
          tail+=tag;
      }
      }
      catch(Exception ex){
          System.out.println("Excepcin");
      }
      
      xml+="    nombre-repositorio=\""+this.getNombreLargo()+"\"\n";
      xml+="    id=\""+this.idMaquina+"\"\n";
      xml+="    id-previa=\""+(this.previa==null?"null":Integer.toString(this.previa.idMaquina))+"\"\n";
      xml+="    id-proxima=\""+(this.proxima==null?"null":Integer.toString(this.proxima.idMaquina))+"\"\n";
      xml+="    x=\""+this.x0+"\"\n";
      xml+="    y=\""+this.y0+"\"\n";
      xml+="    cinta=\""+this.getIndiceCinta()+"\"\n";
      xml+="    inicial=\""+this.isInicial()+"\"\n";
      xml+=tail;
      
      return xml;
    }
    
    public String getLatex(int maxCintas) {
        return "";
    }
    
}
