package cl.jtv;
/*
 * Operandos.java
 *
 * Created on 25 de abril de 2003, 12:24 AM
 */

/**
 *
 * @author  Administrador
 * @version 
 */

import java.util.*; 


public class Operandos {
    
    private Hashtable operandos;
    private Hashtable operandosComplemento;
    private Enlace enlace;
    private CondicionEnlace condicionEnlace;
    /** Creates new Operandos */
    public Operandos(Enlace newEnlace){
        operandos = new Hashtable();
        operandosComplemento = new Hashtable();
        enlace = newEnlace;
        condicionEnlace = enlace.condicionEnlace;
        fillOperandos();
    }
    
    private void fillOperandos(){
        
        java.util.List list = new ArrayList();
        Enumeration enIzq = condicionEnlace.operandosNots.keys();
        while(enIzq.hasMoreElements())
            list.add(enIzq.nextElement());
        Enumeration enDer = condicionEnlace.operandosDerecho.keys();
        while(enDer.hasMoreElements()){
            Object obj = enDer.nextElement();
            if(!list.contains(obj)) list.add(obj);
        }
        Collections.sort(list);
                        
        for(int i=0;i<list.size();i++){
            Integer indexCinta = (Integer)list.get(i);
            if(condicionEnlace.operandosNots.get(indexCinta)==Boolean.FALSE){
                //if(condicionEnlace.operandosDerecho==null)
                //    System.out.println("condicionEnlace.operandosDerecho==null");
                /*if(condicionEnlace.operandosDerecho.get(indexCinta)==null){
                    System.out.println("indexCinta="+indexCinta);
                    System.out.println("condicionEnlace.operandosDerecho.get(indexCinta)==null");
                }*/
                operandos.put(indexCinta,condicionEnlace.operandosDerecho.get(indexCinta));
                
                Vector opDer = (Vector)condicionEnlace.operandosDerecho.get(indexCinta);
                Vector opDerRealesComp = new Vector();
                for(char c='a';c<='z';c++){
                    String simbolo = Simbolo.getSimbolo(c).toString();
                    if(!opDer.contains(simbolo)) opDerRealesComp.add(simbolo);
                }
                for(char c='0';c<='9';c++){
                    String simbolo = Simbolo.getSimbolo(c).toString();
                    if(!opDer.contains(simbolo)) opDerRealesComp.add(simbolo);
                }
                {
                    //Simbolo simbolo = Simbolo.getSimbolo('#');
                    String simbolo = "#";
                    if(!opDer.contains(simbolo)) opDerRealesComp.add(simbolo);
                }
                operandosComplemento.put(indexCinta,opDerRealesComp);    
                    
            }
            else{
                Vector opDer = (Vector)condicionEnlace.operandosDerecho.get(indexCinta);
                Vector opDerReales = new Vector();
                for(char c='a';c<='z';c++){
                    String simbolo = Simbolo.getSimbolo(c).toString();
                    if(!opDer.contains(simbolo)) opDerReales.add(simbolo);
                }
                for(char c='0';c<='9';c++){
                    String simbolo = Simbolo.getSimbolo(c).toString();
                    if(!opDer.contains(simbolo)) opDerReales.add(simbolo);
                }
                {
                    //Simbolo simbolo = Simbolo.getSimbolo('#');
                    String simbolo = "#";
                    if(!opDer.contains(simbolo)) opDerReales.add(simbolo);
                }
                operandos.put(indexCinta,opDerReales);
                operandosComplemento.put(indexCinta,opDer);
            }
        }
              
    }
    
    public Hashtable getComplemento(){
        
        return this.operandosComplemento;
    }
    
    public String getLatex(int maxCintas){
        
        int N = 1;
        int maxSize = 0;
        Integer maxIndexSize = null;
        //int counters[] = new int[operandos.size()];
        //for(int i=0;i<counters.length;i++) counters[i] = 0;
        if(operandos.size()==0){
            String args="";
            for(int j=0;j<maxCintas;j++) args+="*,";
           
            args = args.substring(0,args.length()-1);
            String latex = "";
            if(JTV.flagLatex)
                latex = ("\\delta(q_{"+(enlace.previa.idMaquina)+"},"+args+")=(q_{"+(enlace.proxima.getIndexState())+"},"+args+") \\\\\n"); 
            else
                latex = ("@"+(enlace.previa.idMaquina)+":"+args+"="+(enlace.proxima.getIndexState())+":"+args+"\n"); 
            return latex;            
        }
        
        Enumeration en = operandos.keys();
        while(en.hasMoreElements()){
            Integer indexCinta = (Integer)en.nextElement();
            int size = ((Vector)operandos.get(indexCinta)).size();
            if(size>maxSize){
                maxIndexSize = indexCinta;
                maxSize = size;
            }
            N*=size;   
        }       
        int groupSize = N/maxSize;
        
        String latex = "";
        for(int i=0;i<N;i++){
            String args = ""; 
            for(int j=0;j<maxCintas;j++){
                Integer I = new Integer(j);
                Vector simbolos = (Vector)operandos.get(I);
                if(simbolos==null)
                    args+="*,";
                else{
                    if(I.intValue()==maxIndexSize.intValue()){
                        //int index = (i==0?0:(groupSize%i));
                        //try{    
                        args+=(Utils.escapeBlank((String)simbolos.get(i/groupSize))+",");
                        //}
                        /*catch(Exception ex){
                            System.out.println("index="+index);
                            ex.printStackTrace();
                        }*/
                    }
                    else{
                        //int index = i%simbolos.size(); //(i==0?0:(simbolos.size()%i))-1;
                        //try{
                        args+=(Utils.escapeBlank((String)simbolos.get(i%simbolos.size()))+",");
                        /*}
                        catch(Exception ex){
                            System.out.println("index="+index);
                            ex.printStackTrace();
                        }*/
                    }                   
                }               
            }
            args = args.substring(0,args.length()-1);
            if(JTV.flagLatex)
                latex+=("\\delta(q_{"+(enlace.previa.idMaquina)+"},"+args+")=(q_{"+(enlace.proxima.getIndexState())+"},"+args+") \\\\\n"); 
            else
                latex+=("@"+(enlace.previa.idMaquina)+":"+args+"="+(enlace.proxima.getIndexState())+":"+args+"\n"); 
        }
        
        return latex;
    }
    
    public void print(){
        System.out.println("-----------------OPERANDOS------------------");
        Enumeration en = this.operandos.keys();
        while(en.hasMoreElements()){
            Integer indexCinta = (Integer)en.nextElement();
            System.out.println(indexCinta.toString() + ":" + ((Vector)this.operandos.get(indexCinta)).toString()); 
            
        }
        System.out.println("---------------------------------------------");
        System.out.println("-----------------COMPLEMENTO-----------------");
        en = null;
        en = this.operandosComplemento.keys();
        while(en.hasMoreElements()){
            Integer indexCinta = (Integer)en.nextElement();
            System.out.println(indexCinta.toString() + ":" + ((Vector)this.operandosComplemento.get(indexCinta)).toString()); 
            
        }
        System.out.println("--------------------------------------------------------");
    }
    
    
    /*public static void main(String[] argv){
	
	String[] thesis = new String[]{"Doug", "Evan", "Feng"};
	
	
	String[] grad = new String[]{"Doug", "Feng", "Lida"};

	
	structure.Set thesisSet = new structure.SetList(), 
	    gradSet = new structure.SetList();
		
	
	for(int i = 'a'; i <= 'z'; i++) thesisSet.add(new Character((char)i));
	for(int i = 'k'; i <= 'p'; i++) gradSet.add(new Character((char)i));
	
	
	thesisSet.retainAll(gradSet);
        thesisSet.elements();
	System.out.println(thesisSet);
 }*/

    
}
