package cl.jtv;
/*
 * File:           JTVScanner.java
 * Generated from: JTV.dtd
 * Date:           12 de enero de 2003  11:01 PM
 *
 * @author  Administrador
 * @version generated by FFJ XML module
 */
/**
 * This is a scanner of DOM tree.
 *
 * Example:
 * <pre>
 *     javax.xml.parsers.DocumentBuilderFactory builderFactory = javax.xml.parsers.DocumentBuilderFactory.newInstance();
 *     javax.xml.parsers.DocumentBuilder builder = builderFactory.newDocumentBuilder();
 *     org.w3c.dom.Document document = builder.parse (new org.xml.sax.InputSource (???));
 *     <font color="blue">JTVScanner scanner = new JTVScanner (document);</font>
 *     <font color="blue">scanner.visitDocument();</font>
 * </pre>
 *
 * @see org.w3c.dom.Document
 * @see org.w3c.dom.Element
 * @see org.w3c.dom.NamedNodeMap
 */
import java.util.*;


public class JTVScanner {
    /** org.w3c.dom.Document document */
    org.w3c.dom.Document document;
    Hashtable dicOfMachines;
    Vector2 vector2,principal;
    /** Create new JTVScanner with org.w3c.dom.Document. */
    public JTVScanner(org.w3c.dom.Document document) {
        this.document = document;
        this.dicOfMachines = new Hashtable();
        //this.dicOfReferences = new Hashtable();
    }
    
    /** Scan through org.w3c.dom.Document document. */
    public void visitDocument() {
        org.w3c.dom.Element element = document.getDocumentElement();
        if ((element != null) && element.getTagName().equals("jtv")) {
            visitElement_jtv(element);
        }
        /*if ((element != null) && element.getTagName().equals("configuracion")) {
            visitElement_configuracion(element);
        }
        if ((element != null) && element.getTagName().equals("maquina")) {
            visitElement_maquina(element);
        }
        if ((element != null) && element.getTagName().equals("parametro")) {
            visitElement_parametro(element);
        }
        if ((element != null) && element.getTagName().equals("R")) {
            visitElement_R(element);
        }
        if ((element != null) && element.getTagName().equals("L")) {
            visitElement_L(element);
        }
        if ((element != null) && element.getTagName().equals("escritora")) {
            visitElement_escritora(element);
        }
        if ((element != null) && element.getTagName().equals("submaquina")) {
            visitElement_submaquina(element);
        }
        if ((element != null) && element.getTagName().equals("buscadora-L")) {
            visitElement_buscadora_L(element);
        }
        if ((element != null) && element.getTagName().equals("buscadora-L-NOT")) {
            visitElement_buscadora_L_NOT(element);
        }
        if ((element != null) && element.getTagName().equals("buscadora-R")) {
            visitElement_buscadora_R(element);
        }
        if ((element != null) && element.getTagName().equals("buscadora-R-NOT")) {
            visitElement_buscadora_R_NOT(element);
        }
        if ((element != null) && element.getTagName().equals("SR")) {
            visitElement_SR(element);
        }
        if ((element != null) && element.getTagName().equals("SL")) {
            visitElement_SL(element);
        }
        if ((element != null) && element.getTagName().equals("concentrador")) {
            visitElement_concentrador(element);
        }
        if ((element != null) && element.getTagName().equals("enlace-compuesto")) {
            visitElement_enlace_compuesto(element);
        }
        if ((element != null) && element.getTagName().equals("enlace")) {
            visitElement_enlace(element);
        }
        if ((element != null) && element.getTagName().equals("condicion")) {
            visitElement_condicion(element);
        }
        if ((element != null) && element.getTagName().equals("operando-derecho")) {
            visitElement_operando_derecho(element);
        }
        if ((element != null) && element.getTagName().equals("auto-enlace")) {
            visitElement_auto_enlace(element);
        }*/
    }
    
    /** Scan through org.w3c.dom.Element named jtv. */
    void visitElement_jtv(org.w3c.dom.Element element) { // <jtv>
        // element.getValue();
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    /*if (nodeElement.getTagName().equals("configuracion")) {
                        visitElement_configuracion(nodeElement);
                    }*/
                    if (nodeElement.getTagName().equals("maquina")) {
                        visitElement_maquina(nodeElement);
                    }
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
        
        ReferencesMachine.buildReferences();
        ReferencesMachine.clear();
        /*Enumeration en = dicOfMachines.elements();
        while(en.hasMoreElements()){
            Vector2 vector2 = (Vector2)en.nextElement();
            Enumeration en2 = vector2.elements();
            while(en2.hasMoreElements()){
                Maquina maquina = en2.nextElement();
                if(maquina instanceof Submaquina)
                
            }
        }*/
    }
    
    /** Scan through org.w3c.dom.Element named maquina. */
    void visitElement_maquina(org.w3c.dom.Element element) { // <maquina>
        // element.getValue();
        vector2 = null;
        vector2 = new Vector2();
        vector2.setMonocinta(false);
        
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("nombre-largo")) { // <maquina nombre-largo="???">
                 vector2.setNombreLargo(attr.getValue());
            }
            if (attr.getName().equals("nombre-corto")) { // <maquina nombre-corto="???">
                 vector2.setNombreCorto(attr.getValue());
            }
            if (attr.getName().equals("descripcion")) { // <maquina descripcion="???">
                 vector2.setDescripcion(attr.getValue());
            }
            if (attr.getName().equals("numero-cintas")) { // <maquina numero-cintas="???">
                 vector2.setNumeroCintas(Integer.parseInt(attr.getValue()));
            }
            if (attr.getName().equals("principal")) { // <maquina principal="???">
                 vector2.setPrincipal(attr.getValue().equals("true"));
            }
            if (attr.getName().equals("dependencia")) { // <maquina dependencia="???">
                 vector2.setDependencia(attr.getValue());
            }
        }
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    if (nodeElement.getTagName().equals("parametro")) {
                        visitElement_parametro(nodeElement,null);
                    }
                    if (nodeElement.getTagName().equals("R")) {
                        visitElement_R(nodeElement,vector2);
                    }
                    if (nodeElement.getTagName().equals("L")) {
                        visitElement_L(nodeElement,vector2);
                    }
                    if (nodeElement.getTagName().equals("escritora")) {
                        visitElement_escritora(nodeElement,vector2);
                    }
                    if (nodeElement.getTagName().equals("submaquina")) {
                        visitElement_submaquina(nodeElement,vector2);
                    }
                    if (nodeElement.getTagName().equals("buscadora-L")) {
                        visitElement_buscadora_L(nodeElement,vector2);
                    }
                    if (nodeElement.getTagName().equals("buscadora-L-NOT")) {
                        visitElement_buscadora_L_NOT(nodeElement,vector2);
                    }
                    if (nodeElement.getTagName().equals("buscadora-R")) {
                        visitElement_buscadora_R(nodeElement,vector2);
                    }
                    if (nodeElement.getTagName().equals("buscadora-R-NOT")) {
                        visitElement_buscadora_R_NOT(nodeElement,vector2);
                    }
                    if (nodeElement.getTagName().equals("SR")) {
                        visitElement_SR(nodeElement,vector2);
                    }
                    if (nodeElement.getTagName().equals("SL")) {
                        visitElement_SL(nodeElement,vector2);
                    }
                    if (nodeElement.getTagName().equals("concentrador")) {
                        visitElement_concentrador(nodeElement,vector2);
                    }
                    if (nodeElement.getTagName().equals("enlace-compuesto")) {
                        visitElement_enlace_compuesto(nodeElement,vector2);
                    }
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
        vector2.searchAndSetInicial();
        this.dicOfMachines.put(vector2.getNombreLargo(),vector2);
        if(vector2.isPrincipal()) principal = vector2;
    }
    
    /** Scan through org.w3c.dom.Element named parametro. */
    void visitElement_parametro(org.w3c.dom.Element element,Submaquina submaquina) { // <parametro>
        // element.getValue();
        if(submaquina==null) return; //TRANSITORIO
        
        String nombre=null;
        String valor=null;
        //**********************PENDIENTE*************************
        
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("nombre")) { // <parametro nombre="???">
                nombre = attr.getValue();
            }
            if (attr.getName().equals("valor")) { // <parametro valor="???">
                valor = attr.getValue();
            }
            if(nombre==null || valor==null) continue;
            Parametro parametro = new Parametro(nombre);
            if(!valor.equals("INDEFINIDO")) parametro.setValor(Simbolo.getSimbolo(valor));
            submaquina.parametros.put(nombre,parametro);
            
        }
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named R. */
    void visitElement_R(org.w3c.dom.Element element,Vector2 vector2) { // <R>
        // element.getValue();
        R maquinaR = new R(0,0,0,null,null);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = maquinaR;
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("id")) { // <R id="???">
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) { // <R id-previa="???">
                referencesMachine.idPrevia = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) { // <R id-proxima="???">
                referencesMachine.idProxima = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) { // <R x="???">
                maquinaR.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) { // <R y="???">
                maquinaR.y0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("cinta")) { // <R cinta="???">
                maquinaR.setIndiceCinta(Integer.parseInt(attr.getValue()));
            }
            if (attr.getName().equals("inicial")) { // <R inicial="???">
                maquinaR.setInicial(attr.getValue().equals("true"));
            }
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(maquinaR);
        
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named L. */
    void visitElement_L(org.w3c.dom.Element element,Vector2 vector2) { // <L>
        // element.getValue();
        L maquinaL = new L(0,0,0,null,null);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = maquinaL;
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("id")) { // <L id="???">
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) { // <L id-previa="???">
                referencesMachine.idPrevia = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) { // <L id-proxima="???">
                referencesMachine.idProxima = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) { // <L x="???">
                maquinaL.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) { // <L y="???">
                maquinaL.y0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("cinta")) { // <L cinta="???">
                maquinaL.setIndiceCinta(Integer.parseInt(attr.getValue()));
            }
            if (attr.getName().equals("inicial")) { // <L inicial="???">
                maquinaL.setInicial(attr.getValue().equals("true"));
            }
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(maquinaL);
        
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named escritora. */
    void visitElement_escritora(org.w3c.dom.Element element,Vector2 vector2) { // <escritora>
        // element.getValue();
        Escritora escritora = new Escritora(0,0,0,null,null,"");
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = escritora;
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("nombre")) { // <escritora nombre="???">
                escritora.setNombre(Hellada.XML2symbol(attr.getValue()));
            }
            if (attr.getName().equals("id")) { // <escritora id="???">
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) { // <escritora id-previa="???">
                referencesMachine.idPrevia = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) { // <escritora id-proxima="???">
                referencesMachine.idProxima = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) { // <escritora x="???">
                escritora.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) { // <escritora y="???">
                escritora.y0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("cinta")) { // <escritora cinta="???">
                escritora.setIndiceCinta(Integer.parseInt(attr.getValue()));
            }
            if (attr.getName().equals("inicial")) { // <escritora inicial="???">
                escritora.setInicial(attr.getValue().equals("true"));
            }
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(escritora);
        
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named submaquina. */
    void visitElement_submaquina(org.w3c.dom.Element element,Vector2 vector2) { // <submaquina>
        // element.getValue();
        Submaquina submaquina = new Submaquina(0,0,0,null,null);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = submaquina;
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("nombre-repositorio")) { // <submaquina nombre-repositorio="???">
                submaquina.setNombreLargo(attr.getValue());
                submaquina.setNombreCorto(submaquina.getNombreLargo().substring(0,Math.min(submaquina.getNombreLargo().length(),4)));
            }
            if (attr.getName().equals("id")) { // <submaquina id="???">
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) { // <submaquina id-previa="???">
                referencesMachine.idPrevia = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) { // <submaquina id-proxima="???">
                referencesMachine.idProxima = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) { // <submaquina x="???">
                submaquina.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) { // <submaquina y="???">
                submaquina.y0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("cinta")) { // <submaquina cinta="???">
                submaquina.setIndiceCinta(Integer.parseInt(attr.getValue()));
            }
            if (attr.getName().equals("inicial")) { // <submaquina inicial="???">
                submaquina.setInicial(attr.getValue().equals("true")); 
            }
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(submaquina);
        
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    if (nodeElement.getTagName().equals("parametro")) {
                        visitElement_parametro(nodeElement,submaquina);
                    }
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named buscadora-L. */
    void visitElement_buscadora_L(org.w3c.dom.Element element,Vector2 vector2) { // <buscadora-L>
        // element.getValue();
        Submaquina submaquina = new Submaquina(0,0,0,null,null);
        submaquina.setNombre("L");
        submaquina.setNombreCorto("");
        submaquina.setMonocinta(true);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = submaquina;
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("nombre-repositorio")) { // <buscadora-L nombre-repositorio="???">
                submaquina.setNombreLargo(attr.getValue());
            }
            if (attr.getName().equals("id")) { // <buscadora-L id="???">
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) { // <buscadora-L id-previa="???">
                referencesMachine.idPrevia = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) { // <buscadora-L id-proxima="???">
                referencesMachine.idProxima = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) { // <buscadora-L x="???">
                submaquina.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) { // <buscadora-L y="???">
                submaquina.y0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("cinta")) { // <buscadora-L cinta="???">
                submaquina.setIndiceCinta(Integer.parseInt(attr.getValue()));
            }
            if (attr.getName().equals("inicial")) { // <buscadora-L inicial="???">
                submaquina.setInicial(attr.getValue().equals("true")); 
            }
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(submaquina);
        
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    if (nodeElement.getTagName().equals("parametro")) {
                        visitElement_parametro(nodeElement,submaquina);
                    }
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named buscadora-L-NOT. */
    void visitElement_buscadora_L_NOT(org.w3c.dom.Element element,Vector2 vector2) { // <buscadora-L-NOT>
        // element.getValue();
        Submaquina submaquina = new Submaquina(0,0,0,null,null);
        submaquina.setNombre("L");
        submaquina.setNombreCorto("");
        submaquina.setMonocinta(true);
        submaquina.setNot(true);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = submaquina;
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("nombre-repositorio")) { // <buscadora-L nombre-repositorio="???">
                submaquina.setNombreLargo(attr.getValue());
            }
            if (attr.getName().equals("id")) { // <buscadora-L id="???">
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) { // <buscadora-L id-previa="???">
                referencesMachine.idPrevia = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) { // <buscadora-L id-proxima="???">
                referencesMachine.idProxima = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) { // <buscadora-L x="???">
                submaquina.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) { // <buscadora-L y="???">
                submaquina.y0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("cinta")) { // <buscadora-L cinta="???">
                submaquina.setIndiceCinta(Integer.parseInt(attr.getValue()));
            }
            if (attr.getName().equals("inicial")) { // <buscadora-L inicial="???">
                submaquina.setInicial(attr.getValue().equals("true")); 
            }
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(submaquina);
        
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    if (nodeElement.getTagName().equals("parametro")) {
                        visitElement_parametro(nodeElement,submaquina);
                    }
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named buscadora-R. */
    void visitElement_buscadora_R(org.w3c.dom.Element element,Vector2 vector2) { // <buscadora-R>
        // element.getValue();
        Submaquina submaquina = new Submaquina(0,0,0,null,null);
        submaquina.setNombre("R");
        submaquina.setNombreCorto("");
        submaquina.setMonocinta(true);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = submaquina;
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("nombre-repositorio")) { // <submaquina nombre-repositorio="???">
                submaquina.setNombreLargo(attr.getValue());
            }
            if (attr.getName().equals("id")) { // <submaquina id="???">
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) { // <submaquina id-previa="???">
                referencesMachine.idPrevia = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) { // <submaquina id-proxima="???">
                referencesMachine.idProxima = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) { // <submaquina x="???">
                submaquina.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) { // <submaquina y="???">
                submaquina.y0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("cinta")) { // <submaquina cinta="???">
                submaquina.setIndiceCinta(Integer.parseInt(attr.getValue()));
            }
            if (attr.getName().equals("inicial")) { // <submaquina inicial="???">
                submaquina.setInicial(attr.getValue().equals("true")); 
            }
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(submaquina);
        
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    if (nodeElement.getTagName().equals("parametro")) {
                        visitElement_parametro(nodeElement,submaquina);
                    }
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named buscadora-R-NOT. */
    void visitElement_buscadora_R_NOT(org.w3c.dom.Element element,Vector2 vector2) { // <buscadora-R-NOT>
        // element.getValue();
        Submaquina submaquina = new Submaquina(0,0,0,null,null);
        submaquina.setNombre("R");
        submaquina.setNombreCorto("");
        submaquina.setMonocinta(true);
        submaquina.setNot(true);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = submaquina;
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("nombre-repositorio")) { // <submaquina nombre-repositorio="???">
                submaquina.setNombreLargo(attr.getValue());
            }
            if (attr.getName().equals("id")) { // <submaquina id="???">
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) { // <submaquina id-previa="???">
                referencesMachine.idPrevia = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) { // <submaquina id-proxima="???">
                referencesMachine.idProxima = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) { // <submaquina x="???">
                submaquina.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) { // <submaquina y="???">
                submaquina.y0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("cinta")) { // <submaquina cinta="???">
                submaquina.setIndiceCinta(Integer.parseInt(attr.getValue()));
            }
            if (attr.getName().equals("inicial")) { // <submaquina inicial="???">
                submaquina.setInicial(attr.getValue().equals("true")); 
            }
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(submaquina);
        
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    if (nodeElement.getTagName().equals("parametro")) {
                        visitElement_parametro(nodeElement,submaquina);
                    }
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named SR. */
    void visitElement_SR(org.w3c.dom.Element element,Vector2 vector2) { // <SR>
        // element.getValue();
        Submaquina submaquina = new Submaquina(0,0,0,null,null);
        submaquina.setNombre("S");
        submaquina.setNombreCorto("");
        submaquina.setMonocinta(true);
        Parametro parametro = new Parametro("R");            
        submaquina.parametros.put("R",parametro);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = submaquina;
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("nombre-repositorio")) { // <submaquina nombre-repositorio="???">
                submaquina.setNombreLargo(attr.getValue());
            }
            if (attr.getName().equals("id")) { // <submaquina id="???">
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) { // <submaquina id-previa="???">
                referencesMachine.idPrevia = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) { // <submaquina id-proxima="???">
                referencesMachine.idProxima = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) { // <submaquina x="???">
                submaquina.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) { // <submaquina y="???">
                submaquina.y0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("cinta")) { // <submaquina cinta="???">
                submaquina.setIndiceCinta(Integer.parseInt(attr.getValue()));
            }
            if (attr.getName().equals("inicial")) { // <submaquina inicial="???">
                submaquina.setInicial(attr.getValue().equals("true")); 
            }
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(submaquina);
        
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named SL. */
    void visitElement_SL(org.w3c.dom.Element element,Vector2 vector2) { // <SL>
        // element.getValue();
        Submaquina submaquina = new Submaquina(0,0,0,null,null);
        submaquina.setNombre("S");
        submaquina.setNombreCorto("");
        submaquina.setMonocinta(true);
        Parametro parametro = new Parametro("L");            
        submaquina.parametros.put("L",parametro);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = submaquina;
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("nombre-repositorio")) { // <submaquina nombre-repositorio="???">
                submaquina.setNombreLargo(attr.getValue());
            }
            if (attr.getName().equals("id")) { // <submaquina id="???">
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) { // <submaquina id-previa="???">
                referencesMachine.idPrevia = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) { // <submaquina id-proxima="???">
                referencesMachine.idProxima = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) { // <submaquina x="???">
                submaquina.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) { // <submaquina y="???">
                submaquina.y0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("cinta")) { // <submaquina cinta="???">
                submaquina.setIndiceCinta(Integer.parseInt(attr.getValue()));
            }
            if (attr.getName().equals("inicial")) { // <submaquina inicial="???">
                submaquina.setInicial(attr.getValue().equals("true")); 
            }
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(submaquina);
        
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named concentrador. */
    void visitElement_concentrador(org.w3c.dom.Element element,Vector2 vector2) { // <concentrador>
        // element.getValue();
        Concentrador concentrador = new Concentrador(0,0,0,null,null);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = concentrador;
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("id")) { // <concentrador id="???">
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) { // <concentrador id-proxima="???">
                referencesMachine.idProxima = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) { // <concentrador x="???">
                concentrador.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) { // <concentrador y="???">
                concentrador.y0 = Integer.parseInt(attr.getValue());
            }
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(concentrador);
        
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named enlace-compuesto. */
    void visitElement_enlace_compuesto(org.w3c.dom.Element element,Vector2 vector2) { // <enlace-compuesto>
        // element.getValue();
        EnlaceCompuesto enlaceCompuesto = new EnlaceCompuesto(null);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = enlaceCompuesto;
        
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("id")) { // <enlace-compuesto id="???">
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) { // <enlace-compuesto id-previa="???">
                referencesMachine.idPrevia = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
        }
        ReferencesMachine.put(referencesMachine);
        //No se inserta en vector2
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    if (nodeElement.getTagName().equals("enlace")) {
                        visitElement_enlace(nodeElement,vector2,enlaceCompuesto);
                    }
                    if (nodeElement.getTagName().equals("auto-enlace")) {
                        visitElement_auto_enlace(nodeElement,vector2,enlaceCompuesto);
                    }
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named enlace. */
    void visitElement_enlace(org.w3c.dom.Element element,Vector2 vector2,EnlaceCompuesto enlaceCompuesto) { // <enlace>
        // element.getValue();
        Enlace enlace = new Enlace(0,0);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = enlace;
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("id")) { // <enlace id="???">
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) { // <enlace id-previa="???">
                referencesMachine.idPrevia = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) { // <enlace id-proxima="???">
                referencesMachine.idProxima = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(enlace);
        enlaceCompuesto.insertar(enlace);
        
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    if (nodeElement.getTagName().equals("condicion")) {
                        visitElement_condicion(nodeElement,enlace.condicionEnlace);
                    }
                    if (nodeElement.getTagName().equals("punto")) {
                        visitElement_punto(nodeElement,enlace);
                    }
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named condicion. */
    void visitElement_condicion(org.w3c.dom.Element element,CondicionEnlace condicion) { // <condicion>
        // element.getValue();
        int cinta=0;
        boolean not=false;
        String operandoIzquierdo="";
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("cinta")) { // <condicion cinta="???">
                cinta = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("not")) { // <condicion not="???">
                not = attr.getValue().equals("true");
            }
            if (attr.getName().equals("operando-izquierdo")) { // <condicion operando-izquierdo="???">
                operandoIzquierdo = Hellada.XML2symbol(attr.getValue());
            }
        }
        if(operandoIzquierdo!=null && operandoIzquierdo.trim().length()!=0)
            condicion.agregaOperandoIzquierdo(operandoIzquierdo,cinta);
        //condicion.setNot(not);
        condicion.agregaOperandoNot(not?Boolean.TRUE:Boolean.FALSE,cinta);
        
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    if (nodeElement.getTagName().equals("operando-derecho")) {
                        visitElement_operando_derecho(nodeElement,condicion,cinta);
                    }
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named operando-derecho. */
    void visitElement_operando_derecho(org.w3c.dom.Element element,CondicionEnlace condicion,int cinta) { // <operando-derecho>
        // element.getValue();
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("nombre")) { // <operando-derecho nombre="???">
                condicion.agregaOperandoDerecho(Hellada.XML2symbol(attr.getValue()),cinta);
            }
        }
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named punto. */
    void visitElement_punto(org.w3c.dom.Element element,Enlace enlace) { // <punto>
        // element.getValue();
        int x = 0;
        int y = 0;
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("x")) { // <punto x="???">
                x = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) { // <punto y="???">
                y = Integer.parseInt(attr.getValue());
            }
        }
        enlace.agregaPunto(x,y);
        
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /** Scan through org.w3c.dom.Element named auto-enlace. */
    void visitElement_auto_enlace(org.w3c.dom.Element element,Vector2 vector2,EnlaceCompuesto enlaceCompuesto) { // <auto-enlace>
        // element.getValue();
        AutoEnlace autoEnlace = new AutoEnlace(0,0);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = autoEnlace;
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("id")) { // <auto-enlace id="???">
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) { // <auto-enlace id-previa="???">
                referencesMachine.idPrevia = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) { // <auto-enlace id-proxima="???">
                referencesMachine.idProxima = attr.getValue().equals("null")?null:Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("orientacion")) { // <auto-enlace orientacion="???">
                autoEnlace.setOrientacion(Integer.parseInt(attr.getValue()));
            }
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(autoEnlace);
        enlaceCompuesto.insertar(autoEnlace);
        
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
                    // ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    if (nodeElement.getTagName().equals("condicion")) {
                        visitElement_condicion(nodeElement,autoEnlace.condicionEnlace);
                    }
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
                    // ((org.w3c.dom.ProcessingInstruction)node).getTarget();
                    // ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    public Hashtable getDicOfMachines(){
        return this.dicOfMachines;
    }
    
    /** Getter for property principal.
     * @return Value of property principal.
     */
    public Vector2 getPrincipal() {
        return principal;
    }    
    
    /** Setter for property principal.
     * @param principal New value of property principal.
     */
    public void setPrincipal(Vector2 principal) {
        this.principal = principal;
    }    
    
    /** Getter for property vector2.
     * @return Value of property vector2.
     */
    public Vector2 getVector2() {
        return vector2;
    }
    
    /** Setter for property vector2.
     * @param vector2 New value of property vector2.
     */
    public void setVector2(Vector2 vector2) {
        this.vector2 = vector2;
    }
    
}
