package cl.jtv;
/*
 * StateParser.java
 *
 * Created on 4 de mayo de 2003, 10:05 PM
 */

/**
 *
 * @author  Administrador
 * @version 
 */
import java.util.*;

public class StateParser {
    
    public static final int ABRE_PARENTESIS = 0;
    public static final int CIERRA_PARENTESIS = 1;
    public static final int CUALQUIER_COSA = 2;
    public static final int DIGITO = 3;
    
    /** Creates new StateParser */
    public StateParser() {
    }
    
    
    public static Vector getStates(String latex){
        
        Vector out = new Vector();
        char[] latexArray = latex.toCharArray();
        int state = CUALQUIER_COSA;
        String estado="";
        for(int i=0;i<latexArray.length;i++){
            char c = latexArray[i];
            switch(state){                
                case CUALQUIER_COSA:
                    if(c=='{') state = DIGITO;                    
                    break;                    
                case DIGITO:
                    if(c!='}'){
                        estado+=(""+c);
                    }
                    else{
                        if(!out.contains(estado)) out.add(estado);
                        estado = "";
                        state = CUALQUIER_COSA;
                    }
                    break;                                
            }                        
        }
        latexArray = null;
        return out;
    }
    
    
    public static void main(String args[]){
        
        System.out.println(getStates("{122}ffdsf{5345}fsdfdsf{4567}fdgfdg{-12}fdsf{5345}"));
        
        
    }

}
