package cl.jtv;

/*
 * Parametro.java
 *
 * Created on 3 de octubre de 2002, 03:52 AM
 */

/**
 *
 * @author  Administrador
 * @version 
 */
public class Parametro implements Metavalor,Cloneable {

public static final java.awt.Color VERDE = new java.awt.Color(0,204,0);

private int indice;
private Metavalor valor=null;
private String nombre;
private int referencias;

    /** Creates new Parametro */
    public Parametro(String newNombre) {
        nombre = newNombre;
        referencias=1;
    }
    
    public void setValor(Metavalor newValor){
        
         valor = newValor;
    }
    
     public Metavalor getValor() throws NonSetException{
        
         if(this.isSet())
             return valor.getValor();
         else if(isRunning){
             throw new NonSetParException(); 
         }
         return null;
    }
    
     public boolean equals(Metavalor valor) throws NonSetException{
        
         return this.getValor()==valor.getValor();
    }
    
    public boolean isSet(){
        
         return valor!=null;
    }
    
    public String getNombre() throws NonSetException{
        
        if(isSet())
            return this.valor.getNombre();
        else
            return nombre;
    }    

    public void decrReferencias() {
        this.referencias++;
    }
    
    public void incrReferencias(){
        this.referencias--;
        
    }
    
    public boolean noReferencias() {
        return this.referencias==0;
    }
    
    public String getAsignacion() throws NonSetException {
        
        //return getNombre()+"="+getValor();
        return nombre+"="+(valor==null?"indefinido":valor.getNombre()); 
    }
    
    public void setNombre(String newNombre) {
        nombre = newNombre;
    }
    
    public Object clone(){
        Parametro parametro = new Parametro(nombre);
        parametro.setValor(valor);
        return parametro;
    }
    
}
