package cl.jtv;


//Title:        Proyecto Turing Visual

//Version:

//Copyright:    Copyright (c) 1998

//Author:       Marco Antonio Mora Godoy

//Company:      Your Company

//Description:  No admires, CREA!!!!...





import java.lang.*;

import java.util.*;

import java.awt.*;




class EnlaceCompuesto extends Maquina {

public static int STATE_HALT=-1;
private Vector enlaces;
private int nextState=STATE_HALT;


  EnlaceCompuesto(Maquina prev) {

    super(0,0,null,prev,null);

    enlaces = new Vector(10,1);


  }


  public void accion(){

     return;

  }



  public void dibujar(Graphics g){



    if(enlaces.isEmpty()) return;



    Enumeration en = enlaces.elements();



    while(en.hasMoreElements())

      ((Enlace) en.nextElement()).dibujar(g);



  }



  public void mover(int dx,int dy){
    
    System.out.println("Muevo Enlace Compuesto");

    Object[] arrayEnlaces = enlaces.toArray();
    
    for(int i=0;i<arrayEnlaces.length;i++)
        ((Enlace)arrayEnlaces[i]).mover(dx,dy);
  }
  
  public void moveRewind(){
     return;
  }
  
   public void moveForward(){
     return;
  }
  
  public void moverPrevia(int dx, int dy){
    return;
  }
  
  public void moverProxima(int dx, int dy){
      
    Object[] arrayEnlaces = enlaces.toArray();
    
    for(int i=0;i<arrayEnlaces.length;i++)
        ((Enlace)arrayEnlaces[i]).mover(dx,dy);
   
  }



  public void insertar(Enlace enl){


        enlaces.add(enl);
    

  }
  
  
  public void eliminar(Enlace enl){
      
      
        enlaces.remove(enl);
      
  }
  
  public Enumeration getEnlaces(){
      
        return enlaces.elements();
  }
  
  public int getSize(){
      
        return enlaces.size();
      
  }
  
  public int getEnlacesPosibles(Cinta[] _arrayOfTapes){
      
      int out = 0;
      Enumeration en = this.getEnlaces();
      
      while(en.hasMoreElements()){
          
            Enlace enlace = (Enlace) en.nextElement();
            //char c =_arrayOfTapes[enlace.getIndiceCinta()].leer();
            //if(enlace.condicionEnlace.evaluar(c)) out++;
                
      }
      
      return out;
      
  }

    public boolean hasAutoenlace(){
        
        Enumeration en = this.getEnlaces();
        while(en.hasMoreElements())
            if(en.nextElement() instanceof AutoEnlace) return true;
        
        return false;
        
    }
    
    public String getXML() {
      
      String xml = "";
      xml+="<enlace-compuesto \n";
      xml+="    id=\""+this.idMaquina+"\"\n";
      xml+="    id-previa=\""+(this.previa==null?"null":Integer.toString(this.previa.idMaquina))+"\"\n";
      xml+=">\n";
      
      Enumeration en = this.getEnlaces();
      
      while(en.hasMoreElements()){
          Enlace enlace = (Enlace)en.nextElement();
          xml+=enlace.getXML();
      }
      
      xml+="</enlace-compuesto>\n";
      
      return xml;
    } 
    
    public String getLatex(int maxCintas){
      
       String latex = "";
       Vector vectorOperandos = new Vector();
       Enumeration en = this.getEnlaces();
       while(en.hasMoreElements()){
            Enlace enlace = (Enlace)en.nextElement();
            Operandos operandos = new Operandos(enlace);
            latex+=operandos.getLatex(maxCintas);
            vectorOperandos.add(operandos);         
       }
       Hashtable operandosComplementoInterseccion = getComplementoInterseccion(maxCintas,vectorOperandos);
       
       latex+=getLatexComplemento(maxCintas,operandosComplementoInterseccion);
       
       return latex;
    }
    
    
    private Hashtable getComplementoInterseccion(int maxCintas,Vector vectorOperandos){
        
        Hashtable operandosComplementoInterseccion = new Hashtable(); 
        for(int i=0;i<maxCintas;i++){
            Integer indexCinta = new Integer(i);
            //Los operandos de todos los enlaces
            Enumeration en = vectorOperandos.elements();
            Vector vectorOperandosComplementoCinta = new Vector();
            //Saco los operandos para una cinta de todos los enlaces
            while(en.hasMoreElements()){
                //El operando de 1 enlace
                Hashtable operandosComplemento = ((Operandos)en.nextElement()).getComplemento();
                if(operandosComplemento.containsKey(indexCinta)){
                    Vector vectorOperandosComplementoEnlace = (Vector)operandosComplemento.get(indexCinta);
                    //Object[] arrayOperandosComplemento = ((Vector)operandosComplemento.get(indexCinta)).toArray();
                    /*structure.Set operandosSet = new structure.SetList();
                    for(int j=0;j<arrayOperandosComplemento.length;j++)
                        operandosSet.add(arrayOperandosComplemento[j]);                    
                    vectorSetOperandosComplemento.add(operandosSet);*/
                    vectorOperandosComplementoCinta.add(vectorOperandosComplementoEnlace);
                    
                }                
            }
            
            if(vectorOperandosComplementoCinta.size()==0)
                continue;
            else if(vectorOperandosComplementoCinta.size()==1){
                operandosComplementoInterseccion.put(indexCinta,vectorOperandosComplementoCinta.get(0));
            }
            else{
                Vector vectorInterseccion = new Vector();
                Vector operandosComplementoInicial = (Vector)vectorOperandosComplementoCinta.get(0);
                for(int j=1;j<vectorOperandosComplementoCinta.size();j++){
                    Enumeration en2 = ((Vector)vectorOperandosComplementoCinta.get(j)).elements();
                    while(en2.hasMoreElements()){
                        String operando = (String)en2.nextElement();
                        if(operandosComplementoInicial.contains(operando))
                              vectorInterseccion.add(operando);                     
                    }                    
                }
                operandosComplementoInterseccion.put(indexCinta,vectorInterseccion);
            }            
        }
        return operandosComplementoInterseccion;
    }
    
    private String getLatexComplemento(int maxCintas,Hashtable operandosComplementoInterseccion){
        
        int N = 1;
        int maxSize = 0;
        Integer maxIndexSize = null;
        
        if(operandosComplementoInterseccion.size()==0){
            /*
            String args="";
            for(int j=0;j<maxCintas;j++) args+="*,";
           
            args = args.substring(0,args.length()-1);     
            String latex = ("\\delta(q_{"+(enlace.previa.idMaquina)+"},"+args+")=(q_{"+(enlace.proxima.idMaquina)+"},"+args+") \\\\\n");
              
            return latex;
            */
            return "";
        }
        
        Enumeration en = operandosComplementoInterseccion.keys();
        while(en.hasMoreElements()){
            Integer indexCinta = (Integer)en.nextElement();
            int size = ((Vector)operandosComplementoInterseccion.get(indexCinta)).size();
            if(size>maxSize){
                maxIndexSize = indexCinta;
                maxSize = size;
            }
            N*=size;   
        }       
        int groupSize = N/maxSize;
        
        String latex = "";
        for(int i=0;i<N;i++){
            String args = ""; 
            for(int j=0;j<maxCintas;j++){
                Integer I = new Integer(j);
                Vector simbolos = (Vector)operandosComplementoInterseccion.get(I);
                if(simbolos==null)
                    args+="*,";
                else{
                    if(I.intValue()==maxIndexSize.intValue()){
                        //int index = (i==0?0:(groupSize%i));
                        //try{    
                        args+=(Utils.escapeBlank((String)simbolos.get(i/groupSize))+",");
                        //}
                        /*catch(Exception ex){
                            System.out.println("index="+index);
                            ex.printStackTrace();
                        }*/
                    }
                    else{
                        //int index = i%simbolos.size(); //(i==0?0:(simbolos.size()%i))-1;
                        //try{
                        args+=(Utils.escapeBlank((String)simbolos.get(i%simbolos.size()))+",");
                        /*}
                        catch(Exception ex){
                            System.out.println("index="+index);
                            ex.printStackTrace();
                        }*/
                    }                   
                }               
            }
            args = args.substring(0,args.length()-1);
            if(JTV.flagLatex)
                latex+=("\\delta(q_{"+(this.previa.idMaquina)+"},"+args+")=(q_{"+(nextState==STATE_HALT?"h":nextState+"")+"},"+args+") \\\\\n");
            else
                latex+=("@"+(this.previa.idMaquina)+":"+args+"="+(nextState==STATE_HALT?"h":nextState+"")+":"+args+"\n");
        }
        
        return latex;
        
    }

    /** Getter for property nextState.
     * @return Value of property nextState.
     */
    public int getNextState() {
        return nextState;
    }    
   
    /** Setter for property nextState.
     * @param nextState New value of property nextState.
     */
    public void setNextState(int nextState) {
        this.nextState = nextState;
    }    
    
}

