/*
 * File:           JTVConfigScanner.java
 * Generated from: JTVConfig.dtd
 * Date:           28 de julio de 2007  10:43 PM
 *
 * @author  Tarro
 * @version generated by NetBeans XML module
 */
package cl.jtv;
/**
 *
 * This is a scanner of DOM tree.
 *
 * Example:
 * <pre>
 *     javax.xml.parsers.DocumentBuilderFactory builderFactory = javax.xml.parsers.DocumentBuilderFactory.newInstance();
 *     javax.xml.parsers.DocumentBuilder builder = builderFactory.newDocumentBuilder();
 *     org.w3c.dom.Document document = builder.parse (new org.xml.sax.InputSource (???));
 *     <font color="blue">JTVConfigScanner scanner = new JTVConfigScanner (document);</font>
 *     <font color="blue">scanner.visitDocument();</font>
 * </pre>
 *
 * @see org.w3c.dom.Document
 * @see org.w3c.dom.Element
 * @see org.w3c.dom.NamedNodeMap
 */
public class JTVConfigScanner {
    /**
     * org.w3c.dom.Document document
     */
    org.w3c.dom.Document document;
    
    /**
     * Create new JTVConfigScanner with org.w3c.dom.Document.
     */
    public JTVConfigScanner(org.w3c.dom.Document document) {
        this.document = document;
    }
    
    /**
     * Scan through org.w3c.dom.Document document.
     */
    public void visitDocument() {
        org.w3c.dom.Element element = document.getDocumentElement();
        if ((element != null) && element.getTagName().equals("jtv-config")) {
            visitElement_jtv_config(element);
        }
        if ((element != null) && element.getTagName().equals("maquinas-recientes")) {
            visitElement_maquinas_recientes(element);
        }
        if ((element != null) && element.getTagName().equals("maquina")) {
            visitElement_maquina(element);
        }
    }
    
    /**
     * Scan through org.w3c.dom.Element named jtv-config.
     */
    void visitElement_jtv_config(org.w3c.dom.Element element) { // <jtv-config>
// element.getValue();
        org.w3c.dom.NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); i++) {
            org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);
            if (attr.getName().equals("max-rafaga")) { // <jtv-config max-rafaga="???">
// attr.getValue();
                SharedInteger.setMaxValue(Integer.parseInt(attr.getValue()));
            }
            if (attr.getName().equals("notacion-antigua")) { // <jtv-config notacion-antigua="???">
                Maquina.oldNotation = attr.getValue().equals("true");
// attr.getValue();
            }
        }
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
// ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    if (nodeElement.getTagName().equals("maquinas-recientes")) {
                        visitElement_maquinas_recientes(nodeElement);
                    }
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
// ((org.w3c.dom.ProcessingInstruction)node).getTarget();
// ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /**
     * Scan through org.w3c.dom.Element named maquinas-recientes.
     */
    void visitElement_maquinas_recientes(org.w3c.dom.Element element) { // <maquinas-recientes>
// element.getValue();
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
// ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    if (nodeElement.getTagName().equals("maquina")) {
                        visitElement_maquina(nodeElement);
                    }
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
// ((org.w3c.dom.ProcessingInstruction)node).getTarget();
// ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
            }
        }
    }
    
    /**
     * Scan through org.w3c.dom.Element named maquina.
     */
    void visitElement_maquina(org.w3c.dom.Element element) { // <maquina>
// element.getValue();
        org.w3c.dom.NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            org.w3c.dom.Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case org.w3c.dom.Node.CDATA_SECTION_NODE:
// ((org.w3c.dom.CDATASection)node).getData();
                    break;
                case org.w3c.dom.Node.ELEMENT_NODE:
                    org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;
                    break;
                case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
// ((org.w3c.dom.ProcessingInstruction)node).getTarget();
// ((org.w3c.dom.ProcessingInstruction)node).getData();
                    break;
                case org.w3c.dom.Node.TEXT_NODE:
                    JTV.listaMaquinasRecientes.add(((org.w3c.dom.Text)node).getData());
// ((org.w3c.dom.Text)node).getData();
                    break;
            }
        }
    }
    
    
}
