package cl.jtv;
/*
 * AutoEnlace.java
 *
 * Created on 28 de agosto de 2002, 01:12 AM
 */

/**
 *
 * @author  Administrador
 * @version 
 */
import java.awt.*;
import java.awt.geom.Rectangle2D;
import java.awt.font.FontRenderContext;
import java.util.Enumeration;
import java.util.Vector;


public class AutoEnlace extends Enlace{
    
    
    private double a,b;
    private int alpha,beta;
    private int orientacion;
    private int w,h;
    
    public static final int NORTE = 0;
    public static final int SUR = 1;
    public static final int ESTE = 2;
    public static final int OESTE = 3;
    
    public AutoEnlace(int x,int y) {
        
        super(x,y);
        condicionEnlace = new CondicionEnlace();
        arrow = new Arrow();
        //setExtremos();
        this.setIconValue(JTV.MyRenderer.ICONO_AUTOENLACE);
        //orientacion = _orientacion;
    }

    /** Creates new AutoEnlace */
    public AutoEnlace(int x,int y,int _indiceCinta,Maquina _maquina,int _orientacion) {
        
        super(x,y,_indiceCinta,_maquina,_maquina);
        condicionEnlace = new CondicionEnlace();
        arrow = new Arrow();
        setExtremos();
        this.setIconValue(JTV.MyRenderer.ICONO_AUTOENLACE);
        orientacion = _orientacion;
    }
    
    public void setPoints(){
    
        setExtremos();
    
    }
    
     public void setExtremos(){

      
      Rectangle2D rect1 = Maquina.FONT_TRI25.getStringBounds(previa.getNombre(),new FontRenderContext(Maquina.FONT_TRI25.getTransform(),true,true));
      //Rectangle2D rect2 = Maquina.FONT_TRI25.getStringBounds(proxima.getNombre(),new FontRenderContext(Maquina.FONT_TRI25.getTransform(),true,true));
      
      w = (int)rect1.getWidth();
      h = (int)rect1.getHeight();
      
      switch(orientacion){
          
        case AutoEnlace.NORTE:
            x0 = previa.x0+w+10;
            y0 = previa.y0-h/2+10;
      
            x1 = previa.x0-10;
            y1 = previa.y0-45;
      
            alpha = (int)(Math.atan((y0-y1)/w)*180/Math.PI);
            beta = (int)(180-2*alpha);
            break;
        case AutoEnlace.SUR:
            x0 = previa.x0+w+10;  //15
            y0 = previa.y0+30;    //27
      
            x1 = w+2*previa.x0-x0;
            y1 = previa.y0-h/2+3;
      
            alpha = (int)(Math.atan((y0-y1)/w)*180/Math.PI);
            beta = (int)(180-2*alpha);
            break;
        case AutoEnlace.ESTE:
            h-=10;
            
            x0 = previa.x0+w/2+35;
            y0 = previa.y0+10;
      
            x1 = w/2+previa.x0;
            y1 = previa.y0-h-10;
            
            alpha = (int)(Math.atan((x0-x1)/h)*180/Math.PI);
            beta = (int)(180-2*alpha);
            break;
        case AutoEnlace.OESTE:
            h-=10;
            
            x0 = previa.x0+w/2;
            y0 = previa.y0+10;
      
            x1 = w/2+previa.x0-35;
            y1 = previa.y0-h-10;
            
            alpha = (int)(Math.atan((x0-x1)/h)*180/Math.PI);
            beta = (int)(180-2*alpha);
            break; 
      
      }
      
      /*System.out.println("previa.x0=" + previa.x0);
      System.out.println("previa.y0=" + previa.y0);
      System.out.println("w=" + w);
      System.out.println("h=" + h);
      System.out.println("x0=" + x0);
      System.out.println("y0=" + y0);
      System.out.println("x1=" + x1);
      System.out.println("y1=" + y1);
      System.out.println("alpha=" + alpha);
      System.out.println("beta=" + beta); */
      
  }
  
  public void dibujar(Graphics g){

    if(Maquina.selectedMachine!=null && this==Maquina.selectedMachine)
        g.setColor(Color.magenta);
    else if(JTV.searchedMachine!=null && this==JTV.searchedMachine)
        g.setColor(Color.pink);
    else if(Maquina.playMachine!=null && this==Maquina.playMachine)
        g.setColor(Color.red);
    else
        g.setColor(Color.black);

    g.setFont(Enlace.FONT_TRI10);

    setExtremos();
    java.awt.geom.Rectangle2D rect=null;
    switch(orientacion){
        case AutoEnlace.NORTE:
            g.drawArc(x1,y1,x0-x1,y0-y1,-alpha,360-beta);
            arrow.drawArrow(g,previa.x0+w+1,y0-1,previa.x0+w,y0-1);
            condicionEnlace.setOperandos();
            rect = condicionEnlace.getStringBounds();
            condicionEnlace.x0 = (x0+x1)/2-((int)rect.getWidth()/2);
            condicionEnlace.y0 = y1-(y0-y1)/4+7;
            condicionEnlace.dibujar(g);
            break;
        case AutoEnlace.SUR:
            g.drawArc(x1,y1,x0-x1,y0-y1,alpha+beta,360-beta);
            arrow.drawArrow(g,previa.x0+w+1,y1+1,previa.x0+w,y1);
            condicionEnlace.setOperandos();
            rect = condicionEnlace.getStringBounds();
            condicionEnlace.x0 = (x0+x1)/2-((int)rect.getWidth()/2);
            condicionEnlace.y0 = y0+(y0-y1)/4+5;
            condicionEnlace.dibujar(g);
            break;
        case AutoEnlace.ESTE:
            g.drawArc(x1,y1,x0-x1,y0-y1,270-alpha,360-beta);
            arrow.drawArrow(g,previa.x0+w/2+1,previa.y0-h-1,previa.x0+w/2,previa.y0-h);
            condicionEnlace.setOperandos();
            rect = condicionEnlace.getStringBounds();
            condicionEnlace.x0 = x0+5;
            condicionEnlace.y0 = (y0+y1)/2+((int)rect.getHeight()/2);
            condicionEnlace.dibujar(g);
            break;
        case AutoEnlace.OESTE:
            g.drawArc(x1,y1,x0-x1,y0-y1,90-alpha,360-beta);
            arrow.drawArrow(g,previa.x0+w/2-1,previa.y0-h-1,previa.x0+w/2,previa.y0-h);
            condicionEnlace.setOperandos();
            rect = condicionEnlace.getStringBounds();
            condicionEnlace.x0 = x1-(int)rect.getWidth()-2;
            condicionEnlace.y0 = (y0+y1)/2+((int)rect.getHeight()/2);
            condicionEnlace.dibujar(g);
            break;
    }
    

  }
  
  
  
  public boolean isMouseClicked(int x,int y){
      
        switch(orientacion){
        case AutoEnlace.NORTE:
            //if((g.drawArc(x1,y1,x0-x1,y0-y1,-alpha,360-beta);
            if((new java.awt.geom.Arc2D.Double(x1,y1,x0-x1,y0-y1,-alpha,360-beta,java.awt.geom.Arc2D.OPEN)).intersects(x,y,3,3)) return true;
            break;
        case AutoEnlace.SUR:
            //g.drawArc(x1,y1,x0-x1,y0-y1,alpha+beta,360-beta);
            if((new java.awt.geom.Arc2D.Double(x1,y1,x0-x1,y0-y1,alpha+beta,360-beta,java.awt.geom.Arc2D.OPEN)).intersects(x,y,3,3)) return true;
            break;
        case AutoEnlace.ESTE:
            //g.drawArc(x1,y1,x0-x1,y0-y1,270-alpha,360-beta);
            if((new java.awt.geom.Arc2D.Double(x1,y1,x0-x1,y0-y1,270-alpha,360-beta,java.awt.geom.Arc2D.OPEN)).intersects(x,y,3,3)) return true;
            break;
        case AutoEnlace.OESTE:
            //g.drawArc(x1,y1,x0-x1,y0-y1,90-alpha,360-beta);
            if((new java.awt.geom.Arc2D.Double(x1,y1,x0-x1,y0-y1,90-alpha,360-beta,java.awt.geom.Arc2D.OPEN)).intersects(x,y,3,3)) return true;
            break;
        }
        
        return false;
      
  }
  
  
  public void mover(int dx, int dy){
        return;
  }
  
  public void moverPrevia(int dx, int dy){
    return;
  }
  
  public void moverProxima(int dx, int dy){
    return;
  }
  
   public void moveRewind(){
     return;
  }
  
   public void moveForward(){
     return;
  }
  
  /** Getter for property orientacion.
   * @return Value of property orientacion.
   */
  public int getOrientacion() {
      return orientacion;
  }
  
  /** Setter for property orientacion.
   * @param orientacion New value of property orientacion.
   */
  public void setOrientacion(int orientacion) {
      this.orientacion = orientacion;
  }
  
  public int showDialog(int numOfTapes,boolean addComando){
        
        DialogAutoenlace dv = new DialogAutoenlace(new javax.swing.JFrame (), true,numOfTapes,this,addComando);
        dv.setSize(400,400);
        dv.setVisible(true);
        
        return dv.getReturnStatus();
    }
  
    public String getXML() {
        
      String xml = "";
      xml+="<auto-enlace \n";
      xml+="    id=\""+this.idMaquina+"\"\n";
      xml+="    id-previa=\""+this.previa.idMaquina+"\"\n";
      xml+="    id-proxima=\""+this.proxima.idMaquina+"\"\n";
      xml+="    orientacion=\""+this.orientacion+"\"\n";
      
      if(this.condicionEnlace.operandosDerecho.size()==0 && this.condicionEnlace.operandosIzquierdo.size()==0 ){
          xml+="/>\n\n";
          return xml;
      }
      xml+=">\n\n";
      
      Enumeration en = this.condicionEnlace.operandosDerecho.keys();
      
      while(en.hasMoreElements()){
            Integer indexCinta = (Integer)en.nextElement();
            Vector operandosDerecho = (Vector)this.condicionEnlace.operandosDerecho.get(indexCinta);
            xml+="    <condicion cinta=\""+indexCinta+"\" not=\""+((Boolean)this.condicionEnlace.operandosNots.get(indexCinta)).toString()+"\"";
            if(this.condicionEnlace.operandosIzquierdo.containsKey(indexCinta)){
                String operandoIzquierdo = (String)this.condicionEnlace.operandosIzquierdo.get(indexCinta);
                xml+=" operando-izquierdo=\""+Hellada.symbol2XML(operandoIzquierdo)+"\"";
            }
            
            if(operandosDerecho.size()==0){
                 xml+="/>\n";
                 continue;
            }
            xml+=">\n";
            Enumeration en2 = operandosDerecho.elements();
            while(en2.hasMoreElements()){
                String operandoDerecho = (String)en2.nextElement();
                xml+="          <operando-derecho nombre=\""+Hellada.symbol2XML(operandoDerecho)+"\"/>\n";
            }
            xml+="     </condicion>\n";
      }
      
      en = null;
      en = this.condicionEnlace.operandosIzquierdo.keys();
      
      while(en.hasMoreElements()){
            Integer indexCinta = (Integer)en.nextElement();
            if(this.condicionEnlace.operandosDerecho.containsKey(indexCinta)) continue;
            String operandoIzquierdo = (String)this.condicionEnlace.operandosIzquierdo.get(indexCinta);
            xml+="     <condicion cinta=\""+indexCinta+"\" not=\""+((Boolean)this.condicionEnlace.operandosNots.get(indexCinta)).toString()+"\"";
            xml+=" operando-izquierdo=\""+Hellada.symbol2XML(operandoIzquierdo)+"\"/>\n"; 
      }
      
      
      xml+="</auto-enlace>\n";
      
      return xml;
  
    } 
}
