/*
 * Decompiled with CFR 0.152.
 */
package cl.jtv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class JTV_SOC {
    public static Integer HALT_STATE = new Integer(Integer.MAX_VALUE);
    public static Integer COLGADA_STATE = new Integer(Integer.MIN_VALUE);
    public static int MAX_CICLOS = 40;

    public JTV_SOC(String[] args) {
        try {
            int i;
            File file = new File(args[0]);
            BufferedReader br = new BufferedReader(new FileReader(file));
            String data = "";
            String linea = null;
            while ((linea = br.readLine()) != null) {
                data = data + linea + "\n";
            }
            Integer state = null;
            Integer startState = null;
            int numeroCintas = 0;
            StringTokenizer st = new StringTokenizer(data, "@");
            int counter = 0;
            Hashtable<Integer, Vector> tablaDelta = new Hashtable<Integer, Vector>();
            while (st.hasMoreElements()) {
                linea = ((String)st.nextElement()).trim();
                if (counter == 0) {
                    numeroCintas = Integer.parseInt(linea);
                } else if (counter == 1) {
                    startState = new Integer(linea);
                } else {
                    Vector vector;
                    StringTokenizer st2 = new StringTokenizer(linea, "=");
                    Condicion condicion = new Condicion(st2.nextToken());
                    condicion.accion = new Accion(st2.nextToken());
                    if (!tablaDelta.containsKey(condicion.state)) {
                        vector = new Vector();
                        vector.add(condicion);
                        tablaDelta.put(condicion.state, vector);
                    } else {
                        vector = (Vector)tablaDelta.get(condicion.state);
                        vector.add(condicion);
                    }
                }
                ++counter;
            }
            Vector<Tape> cintas = new Vector<Tape>();
            for (i = 1; i <= numeroCintas; ++i) {
                if (i < args.length) {
                    cintas.add(new Tape(i, args[i]));
                    continue;
                }
                cintas.add(new Tape(i));
            }
            System.out.println("Entrada:");
            for (i = 0; i < cintas.size(); ++i) {
                ((Tape)cintas.get(i)).print();
            }
            System.out.println("Ejecutando MT...");
            state = startState;
            int ciclos = 0;
            Vector<Condicion> vectorCondicionesVerdaderas = new Vector<Condicion>();
            while (!state.equals(COLGADA_STATE) && !state.equals(HALT_STATE)) {
                Vector vectorDelta = (Vector)tablaDelta.get(state);
                Enumeration en = vectorDelta.elements();
                while (en.hasMoreElements()) {
                    Condicion condicion = (Condicion)en.nextElement();
                    if (!condicion.evaluar(cintas)) continue;
                    vectorCondicionesVerdaderas.add(condicion);
                }
                int condicionesVerdaderas = vectorCondicionesVerdaderas.size();
                if (condicionesVerdaderas == 0) {
                    System.out.println("ERROR EN LA EJECUCION: ESTADO NO ENCONTRADO!!!");
                    return;
                }
                if (condicionesVerdaderas == 1) {
                    Condicion condicion = (Condicion)vectorCondicionesVerdaderas.get(0);
                    state = condicion.accion.accion(cintas);
                    vectorCondicionesVerdaderas.removeAllElements();
                } else if (condicionesVerdaderas > 1) {
                    System.out.println("Se produjo ND");
                    System.out.print("Existen " + condicionesVerdaderas + " configuraciones diferentes. Elija una:");
                    while (true) {
                        int input = 0;
                        Vector<String> vectorInput = new Vector<String>();
                        while ((input = System.in.read()) != 10) {
                            vectorInput.add(input + "");
                        }
                        String strInput = (String)vectorInput.get(0);
                        vectorInput.removeAllElements();
                        int intInput = 0;
                        try {
                            intInput = Integer.parseInt(strInput);
                            intInput -= 48;
                        }
                        catch (NumberFormatException ex) {
                            System.out.println("Debe ingresar un n\u00famero entre 1 y " + condicionesVerdaderas);
                        }
                        if (1 <= intInput && intInput <= condicionesVerdaderas) {
                            Condicion condicion = (Condicion)vectorCondicionesVerdaderas.get(intInput - 1);
                            state = condicion.accion.accion(cintas);
                            vectorCondicionesVerdaderas.removeAllElements();
                            for (int i2 = 0; i2 < cintas.size(); ++i2) {
                                ((Tape)cintas.get(i2)).print();
                            }
                            break;
                        }
                        System.out.println("Debe ingresar un n\u00famero entre 1 y " + condicionesVerdaderas);
                    }
                }
                if (++ciclos != MAX_CICLOS) continue;
                for (int i3 = 0; i3 < cintas.size(); ++i3) {
                    ((Tape)cintas.get(i3)).print();
                }
                System.out.print("Sigue?(s/n):");
                int input = System.in.read();
                boolean breakLoop = false;
                while ((input = System.in.read()) != 10) {
                    if (input == 78 || input == 110) {
                        breakLoop = true;
                        continue;
                    }
                    ciclos = 0;
                }
                if (!breakLoop) continue;
                System.out.println("Ejecuci\u00f3n Suspendida...");
                break;
            }
            if (state == COLGADA_STATE) {
                System.out.println("MAQUINA COLGADA!!!");
                return;
            }
            for (int i4 = 0; i4 < cintas.size(); ++i4) {
                ((Tape)cintas.get(i4)).print();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JTV_SOC jtvSOC = new JTV_SOC(args);
    }

    public class Tape {
        public String contenido;
        public int indice;
        public int numero;

        public Tape(int newNumero, String newContenido) {
            this.contenido = new String(newContenido);
            this.indice = this.contenido.length() + 1;
            this.numero = newNumero;
            this.contenido = "#" + this.contenido + "#";
        }

        public Tape(int newNumero) {
            this.contenido = "#";
            this.indice = 0;
            this.numero = newNumero;
        }

        public boolean accion(String accion) {
            if (accion.equals("R")) {
                ++this.indice;
                if (this.indice > this.contenido.length() - 1) {
                    this.contenido = this.contenido + "#";
                }
            } else if (accion.equals("L")) {
                --this.indice;
            } else if (!accion.equals("*")) {
                char[] arreglo = this.contenido.toCharArray();
                arreglo[this.indice] = accion.charAt(0);
                this.contenido = new String(arreglo);
            }
            return this.indice >= 0;
        }

        public String leer() {
            return this.contenido.charAt(this.indice) + "";
        }

        public void print() {
            System.out.println(this.numero + ":" + this.contenido);
            System.out.print("  ");
            for (int i = 0; i < this.indice; ++i) {
                System.out.print(" ");
            }
            System.out.println("-");
        }
    }

    public class Accion {
        public Integer state;
        public Vector acciones;

        public Accion(String accion) {
            StringTokenizer st = new StringTokenizer(accion, ":");
            String stringState = st.nextToken();
            this.state = stringState.equals("h") ? HALT_STATE : new Integer(stringState);
            String conds = st.nextToken();
            st = null;
            st = new StringTokenizer(conds, ",");
            this.acciones = new Vector();
            while (st.hasMoreTokens()) {
                this.acciones.add(st.nextToken());
            }
            st = null;
        }

        public Integer accion(Vector cintas) {
            for (int i = 0; i < this.acciones.size(); ++i) {
                if (((Tape)cintas.get(i)).accion((String)this.acciones.get(i))) continue;
                return COLGADA_STATE;
            }
            return this.state;
        }
    }

    public class Condicion {
        public Integer state;
        public Vector condiciones;
        public Accion accion;

        public Condicion(String condicion) {
            StringTokenizer st = new StringTokenizer(condicion, ":");
            String stringState = st.nextToken();
            this.state = stringState.equals("h") ? HALT_STATE : new Integer(stringState);
            String conds = st.nextToken();
            st = null;
            st = new StringTokenizer(conds, ",");
            this.condiciones = new Vector();
            while (st.hasMoreTokens()) {
                this.condiciones.add(st.nextToken());
            }
            st = null;
            this.accion = this.accion;
        }

        public boolean evaluar(Vector cintas) {
            for (int i = 0; i < this.condiciones.size(); ++i) {
                if (this.condiciones.get(i).equals("*") || this.condiciones.get(i).equals(((Tape)cintas.get(i)).leer())) continue;
                return false;
            }
            return true;
        }
    }
}

