/*
 * Decompiled with CFR 0.152.
 */
package cl.jtv;

import cl.jtv.AutoEnlace;
import cl.jtv.Concentrador;
import cl.jtv.CondicionEnlace;
import cl.jtv.Enlace;
import cl.jtv.EnlaceCompuesto;
import cl.jtv.Escritora;
import cl.jtv.Hellada;
import cl.jtv.L;
import cl.jtv.Parametro;
import cl.jtv.R;
import cl.jtv.ReferencesMachine;
import cl.jtv.Simbolo;
import cl.jtv.Submaquina;
import cl.jtv.Vector2;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JTVScanner {
    Document document;
    Hashtable dicOfMachines;
    Vector2 vector2;
    Vector2 principal;

    public JTVScanner(Document document) {
        this.document = document;
        this.dicOfMachines = new Hashtable();
    }

    public void visitDocument() {
        Element element = this.document.getDocumentElement();
        if (element != null && element.getTagName().equals("jtv")) {
            this.visitElement_jtv(element);
        }
    }

    void visitElement_jtv(Element element) {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("maquina")) continue block4;
                    this.visitElement_maquina(nodeElement);
                    continue block4;
                }
            }
        }
        ReferencesMachine.buildReferences();
        ReferencesMachine.clear();
    }

    void visitElement_maquina(Element element) {
        this.vector2 = null;
        this.vector2 = new Vector2();
        this.vector2.setMonocinta(false);
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("nombre-largo")) {
                this.vector2.setNombreLargo(attr.getValue());
            }
            if (attr.getName().equals("nombre-corto")) {
                this.vector2.setNombreCorto(attr.getValue());
            }
            if (attr.getName().equals("descripcion")) {
                this.vector2.setDescripcion(attr.getValue());
            }
            if (attr.getName().equals("numero-cintas")) {
                this.vector2.setNumeroCintas(Integer.parseInt(attr.getValue()));
            }
            if (attr.getName().equals("principal")) {
                this.vector2.setPrincipal(attr.getValue().equals("true"));
            }
            if (!attr.getName().equals("dependencia")) continue;
            this.vector2.setDependencia(attr.getValue());
        }
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (nodeElement.getTagName().equals("parametro")) {
                        this.visitElement_parametro(nodeElement, null);
                    }
                    if (nodeElement.getTagName().equals("R")) {
                        this.visitElement_R(nodeElement, this.vector2);
                    }
                    if (nodeElement.getTagName().equals("L")) {
                        this.visitElement_L(nodeElement, this.vector2);
                    }
                    if (nodeElement.getTagName().equals("escritora")) {
                        this.visitElement_escritora(nodeElement, this.vector2);
                    }
                    if (nodeElement.getTagName().equals("submaquina")) {
                        this.visitElement_submaquina(nodeElement, this.vector2);
                    }
                    if (nodeElement.getTagName().equals("buscadora-L")) {
                        this.visitElement_buscadora_L(nodeElement, this.vector2);
                    }
                    if (nodeElement.getTagName().equals("buscadora-L-NOT")) {
                        this.visitElement_buscadora_L_NOT(nodeElement, this.vector2);
                    }
                    if (nodeElement.getTagName().equals("buscadora-R")) {
                        this.visitElement_buscadora_R(nodeElement, this.vector2);
                    }
                    if (nodeElement.getTagName().equals("buscadora-R-NOT")) {
                        this.visitElement_buscadora_R_NOT(nodeElement, this.vector2);
                    }
                    if (nodeElement.getTagName().equals("SR")) {
                        this.visitElement_SR(nodeElement, this.vector2);
                    }
                    if (nodeElement.getTagName().equals("SL")) {
                        this.visitElement_SL(nodeElement, this.vector2);
                    }
                    if (nodeElement.getTagName().equals("concentrador")) {
                        this.visitElement_concentrador(nodeElement, this.vector2);
                    }
                    if (!nodeElement.getTagName().equals("enlace-compuesto")) continue block5;
                    this.visitElement_enlace_compuesto(nodeElement, this.vector2);
                    continue block5;
                }
            }
        }
        this.vector2.searchAndSetInicial();
        this.dicOfMachines.put(this.vector2.getNombreLargo(), this.vector2);
        if (this.vector2.isPrincipal()) {
            this.principal = this.vector2;
        }
    }

    void visitElement_parametro(Element element, Submaquina submaquina) {
        if (submaquina == null) {
            return;
        }
        String nombre = null;
        String valor = null;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("nombre")) {
                nombre = attr.getValue();
            }
            if (attr.getName().equals("valor")) {
                valor = attr.getValue();
            }
            if (nombre == null || valor == null) continue;
            Parametro parametro = new Parametro(nombre);
            if (!valor.equals("INDEFINIDO")) {
                parametro.setValor(Simbolo.getSimbolo(valor));
            }
            submaquina.parametros.put(nombre, parametro);
        }
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    continue block5;
                }
            }
        }
    }

    void visitElement_R(Element element, Vector2 vector2) {
        R maquinaR = new R(0, 0, 0, null, null);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = maquinaR;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("id")) {
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) {
                Integer n = referencesMachine.idPrevia = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) {
                Integer n = referencesMachine.idProxima = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) {
                maquinaR.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) {
                maquinaR.y0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("cinta")) {
                maquinaR.setIndiceCinta(Integer.parseInt(attr.getValue()));
            }
            if (!attr.getName().equals("inicial")) continue;
            maquinaR.setInicial(attr.getValue().equals("true"));
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(maquinaR);
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    continue block5;
                }
            }
        }
    }

    void visitElement_L(Element element, Vector2 vector2) {
        L maquinaL = new L(0, 0, 0, null, null);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = maquinaL;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("id")) {
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) {
                Integer n = referencesMachine.idPrevia = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) {
                Integer n = referencesMachine.idProxima = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) {
                maquinaL.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) {
                maquinaL.y0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("cinta")) {
                maquinaL.setIndiceCinta(Integer.parseInt(attr.getValue()));
            }
            if (!attr.getName().equals("inicial")) continue;
            maquinaL.setInicial(attr.getValue().equals("true"));
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(maquinaL);
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    continue block5;
                }
            }
        }
    }

    void visitElement_escritora(Element element, Vector2 vector2) {
        Escritora escritora = new Escritora(0, 0, 0, null, null, "");
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = escritora;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("nombre")) {
                escritora.setNombre(Hellada.XML2symbol(attr.getValue()));
            }
            if (attr.getName().equals("id")) {
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) {
                Integer n = referencesMachine.idPrevia = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) {
                Integer n = referencesMachine.idProxima = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) {
                escritora.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) {
                escritora.y0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("cinta")) {
                escritora.setIndiceCinta(Integer.parseInt(attr.getValue()));
            }
            if (!attr.getName().equals("inicial")) continue;
            escritora.setInicial(attr.getValue().equals("true"));
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(escritora);
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    continue block5;
                }
            }
        }
    }

    void visitElement_submaquina(Element element, Vector2 vector2) {
        Submaquina submaquina = new Submaquina(0, 0, 0, null, null);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = submaquina;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("nombre-repositorio")) {
                submaquina.setNombreLargo(attr.getValue());
                submaquina.setNombreCorto(submaquina.getNombreLargo().substring(0, Math.min(submaquina.getNombreLargo().length(), 4)));
            }
            if (attr.getName().equals("id")) {
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) {
                Integer n = referencesMachine.idPrevia = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) {
                Integer n = referencesMachine.idProxima = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) {
                submaquina.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) {
                submaquina.y0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("cinta")) {
                submaquina.setIndiceCinta(Integer.parseInt(attr.getValue()));
            }
            if (!attr.getName().equals("inicial")) continue;
            submaquina.setInicial(attr.getValue().equals("true"));
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(submaquina);
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("parametro")) continue block5;
                    this.visitElement_parametro(nodeElement, submaquina);
                    continue block5;
                }
            }
        }
    }

    void visitElement_buscadora_L(Element element, Vector2 vector2) {
        Submaquina submaquina = new Submaquina(0, 0, 0, null, null);
        submaquina.setNombre("L");
        submaquina.setNombreCorto("");
        submaquina.setMonocinta(true);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = submaquina;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("nombre-repositorio")) {
                submaquina.setNombreLargo(attr.getValue());
            }
            if (attr.getName().equals("id")) {
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) {
                Integer n = referencesMachine.idPrevia = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) {
                Integer n = referencesMachine.idProxima = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) {
                submaquina.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) {
                submaquina.y0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("cinta")) {
                submaquina.setIndiceCinta(Integer.parseInt(attr.getValue()));
            }
            if (!attr.getName().equals("inicial")) continue;
            submaquina.setInicial(attr.getValue().equals("true"));
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(submaquina);
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("parametro")) continue block5;
                    this.visitElement_parametro(nodeElement, submaquina);
                    continue block5;
                }
            }
        }
    }

    void visitElement_buscadora_L_NOT(Element element, Vector2 vector2) {
        Submaquina submaquina = new Submaquina(0, 0, 0, null, null);
        submaquina.setNombre("L");
        submaquina.setNombreCorto("");
        submaquina.setMonocinta(true);
        submaquina.setNot(true);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = submaquina;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("nombre-repositorio")) {
                submaquina.setNombreLargo(attr.getValue());
            }
            if (attr.getName().equals("id")) {
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) {
                Integer n = referencesMachine.idPrevia = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) {
                Integer n = referencesMachine.idProxima = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) {
                submaquina.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) {
                submaquina.y0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("cinta")) {
                submaquina.setIndiceCinta(Integer.parseInt(attr.getValue()));
            }
            if (!attr.getName().equals("inicial")) continue;
            submaquina.setInicial(attr.getValue().equals("true"));
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(submaquina);
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("parametro")) continue block5;
                    this.visitElement_parametro(nodeElement, submaquina);
                    continue block5;
                }
            }
        }
    }

    void visitElement_buscadora_R(Element element, Vector2 vector2) {
        Submaquina submaquina = new Submaquina(0, 0, 0, null, null);
        submaquina.setNombre("R");
        submaquina.setNombreCorto("");
        submaquina.setMonocinta(true);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = submaquina;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("nombre-repositorio")) {
                submaquina.setNombreLargo(attr.getValue());
            }
            if (attr.getName().equals("id")) {
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) {
                Integer n = referencesMachine.idPrevia = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) {
                Integer n = referencesMachine.idProxima = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) {
                submaquina.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) {
                submaquina.y0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("cinta")) {
                submaquina.setIndiceCinta(Integer.parseInt(attr.getValue()));
            }
            if (!attr.getName().equals("inicial")) continue;
            submaquina.setInicial(attr.getValue().equals("true"));
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(submaquina);
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("parametro")) continue block5;
                    this.visitElement_parametro(nodeElement, submaquina);
                    continue block5;
                }
            }
        }
    }

    void visitElement_buscadora_R_NOT(Element element, Vector2 vector2) {
        Submaquina submaquina = new Submaquina(0, 0, 0, null, null);
        submaquina.setNombre("R");
        submaquina.setNombreCorto("");
        submaquina.setMonocinta(true);
        submaquina.setNot(true);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = submaquina;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("nombre-repositorio")) {
                submaquina.setNombreLargo(attr.getValue());
            }
            if (attr.getName().equals("id")) {
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) {
                Integer n = referencesMachine.idPrevia = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) {
                Integer n = referencesMachine.idProxima = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) {
                submaquina.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) {
                submaquina.y0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("cinta")) {
                submaquina.setIndiceCinta(Integer.parseInt(attr.getValue()));
            }
            if (!attr.getName().equals("inicial")) continue;
            submaquina.setInicial(attr.getValue().equals("true"));
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(submaquina);
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("parametro")) continue block5;
                    this.visitElement_parametro(nodeElement, submaquina);
                    continue block5;
                }
            }
        }
    }

    void visitElement_SR(Element element, Vector2 vector2) {
        Submaquina submaquina = new Submaquina(0, 0, 0, null, null);
        submaquina.setNombre("S");
        submaquina.setNombreCorto("");
        submaquina.setMonocinta(true);
        Parametro parametro = new Parametro("R");
        submaquina.parametros.put("R", parametro);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = submaquina;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("nombre-repositorio")) {
                submaquina.setNombreLargo(attr.getValue());
            }
            if (attr.getName().equals("id")) {
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) {
                Integer n = referencesMachine.idPrevia = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) {
                Integer n = referencesMachine.idProxima = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) {
                submaquina.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) {
                submaquina.y0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("cinta")) {
                submaquina.setIndiceCinta(Integer.parseInt(attr.getValue()));
            }
            if (!attr.getName().equals("inicial")) continue;
            submaquina.setInicial(attr.getValue().equals("true"));
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(submaquina);
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    continue block5;
                }
            }
        }
    }

    void visitElement_SL(Element element, Vector2 vector2) {
        Submaquina submaquina = new Submaquina(0, 0, 0, null, null);
        submaquina.setNombre("S");
        submaquina.setNombreCorto("");
        submaquina.setMonocinta(true);
        Parametro parametro = new Parametro("L");
        submaquina.parametros.put("L", parametro);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = submaquina;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("nombre-repositorio")) {
                submaquina.setNombreLargo(attr.getValue());
            }
            if (attr.getName().equals("id")) {
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) {
                Integer n = referencesMachine.idPrevia = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) {
                Integer n = referencesMachine.idProxima = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) {
                submaquina.x0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("y")) {
                submaquina.y0 = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("cinta")) {
                submaquina.setIndiceCinta(Integer.parseInt(attr.getValue()));
            }
            if (!attr.getName().equals("inicial")) continue;
            submaquina.setInicial(attr.getValue().equals("true"));
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(submaquina);
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    continue block5;
                }
            }
        }
    }

    void visitElement_concentrador(Element element, Vector2 vector2) {
        Concentrador concentrador = new Concentrador(0, 0, 0, null, null);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = concentrador;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("id")) {
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) {
                Integer n = referencesMachine.idProxima = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("x")) {
                concentrador.x0 = Integer.parseInt(attr.getValue());
            }
            if (!attr.getName().equals("y")) continue;
            concentrador.y0 = Integer.parseInt(attr.getValue());
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(concentrador);
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    continue block5;
                }
            }
        }
    }

    void visitElement_enlace_compuesto(Element element, Vector2 vector2) {
        EnlaceCompuesto enlaceCompuesto = new EnlaceCompuesto(null);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = enlaceCompuesto;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("id")) {
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (!attr.getName().equals("id-previa")) continue;
            referencesMachine.idPrevia = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
        }
        ReferencesMachine.put(referencesMachine);
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (nodeElement.getTagName().equals("enlace")) {
                        this.visitElement_enlace(nodeElement, vector2, enlaceCompuesto);
                    }
                    if (!nodeElement.getTagName().equals("auto-enlace")) continue block5;
                    this.visitElement_auto_enlace(nodeElement, vector2, enlaceCompuesto);
                    continue block5;
                }
            }
        }
    }

    void visitElement_enlace(Element element, Vector2 vector2, EnlaceCompuesto enlaceCompuesto) {
        Enlace enlace = new Enlace(0, 0);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = enlace;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("id")) {
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) {
                Integer n = referencesMachine.idPrevia = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (!attr.getName().equals("id-proxima")) continue;
            referencesMachine.idProxima = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(enlace);
        enlaceCompuesto.insertar(enlace);
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (nodeElement.getTagName().equals("condicion")) {
                        this.visitElement_condicion(nodeElement, enlace.condicionEnlace);
                    }
                    if (!nodeElement.getTagName().equals("punto")) continue block5;
                    this.visitElement_punto(nodeElement, enlace);
                    continue block5;
                }
            }
        }
    }

    void visitElement_condicion(Element element, CondicionEnlace condicion) {
        int cinta = 0;
        boolean not = false;
        String operandoIzquierdo = "";
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("cinta")) {
                cinta = Integer.parseInt(attr.getValue());
            }
            if (attr.getName().equals("not")) {
                not = attr.getValue().equals("true");
            }
            if (!attr.getName().equals("operando-izquierdo")) continue;
            operandoIzquierdo = Hellada.XML2symbol(attr.getValue());
        }
        if (operandoIzquierdo != null && operandoIzquierdo.trim().length() != 0) {
            condicion.agregaOperandoIzquierdo(operandoIzquierdo, cinta);
        }
        condicion.agregaOperandoNot(not ? Boolean.TRUE : Boolean.FALSE, cinta);
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("operando-derecho")) continue block5;
                    this.visitElement_operando_derecho(nodeElement, condicion, cinta);
                    continue block5;
                }
            }
        }
    }

    void visitElement_operando_derecho(Element element, CondicionEnlace condicion, int cinta) {
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!attr.getName().equals("nombre")) continue;
            condicion.agregaOperandoDerecho(Hellada.XML2symbol(attr.getValue()), cinta);
        }
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    continue block5;
                }
            }
        }
    }

    void visitElement_punto(Element element, Enlace enlace) {
        int x = 0;
        int y = 0;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("x")) {
                x = Integer.parseInt(attr.getValue());
            }
            if (!attr.getName().equals("y")) continue;
            y = Integer.parseInt(attr.getValue());
        }
        enlace.agregaPunto(x, y);
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    continue block5;
                }
            }
        }
    }

    void visitElement_auto_enlace(Element element, Vector2 vector2, EnlaceCompuesto enlaceCompuesto) {
        AutoEnlace autoEnlace = new AutoEnlace(0, 0);
        ReferencesMachine referencesMachine = new ReferencesMachine();
        referencesMachine.machine = autoEnlace;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("id")) {
                referencesMachine.id = Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-previa")) {
                Integer n = referencesMachine.idPrevia = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (attr.getName().equals("id-proxima")) {
                Integer n = referencesMachine.idProxima = attr.getValue().equals("null") ? null : Integer.valueOf(attr.getValue());
            }
            if (!attr.getName().equals("orientacion")) continue;
            autoEnlace.setOrientacion(Integer.parseInt(attr.getValue()));
        }
        ReferencesMachine.put(referencesMachine);
        vector2.add2(autoEnlace);
        enlaceCompuesto.insertar(autoEnlace);
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("condicion")) continue block5;
                    this.visitElement_condicion(nodeElement, autoEnlace.condicionEnlace);
                    continue block5;
                }
            }
        }
    }

    public Hashtable getDicOfMachines() {
        return this.dicOfMachines;
    }

    public Vector2 getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Vector2 principal) {
        this.principal = principal;
    }

    public Vector2 getVector2() {
        return this.vector2;
    }

    public void setVector2(Vector2 vector2) {
        this.vector2 = vector2;
    }
}

