/*
 * Decompiled with CFR 0.152.
 */
package cl.jtv;

import cl.jtv.Arrow;
import cl.jtv.CondicionEnlace;
import cl.jtv.DialogAutoenlace;
import cl.jtv.Enlace;
import cl.jtv.Hellada;
import cl.jtv.JTV;
import cl.jtv.Maquina;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;

public class AutoEnlace
extends Enlace {
    private double a;
    private double b;
    private int alpha;
    private int beta;
    private int orientacion;
    private int w;
    private int h;
    public static final int NORTE = 0;
    public static final int SUR = 1;
    public static final int ESTE = 2;
    public static final int OESTE = 3;

    public AutoEnlace(int x, int y) {
        super(x, y);
        this.condicionEnlace = new CondicionEnlace();
        this.arrow = new Arrow();
        this.setIconValue(5);
    }

    public AutoEnlace(int x, int y, int _indiceCinta, Maquina _maquina, int _orientacion) {
        super(x, y, _indiceCinta, _maquina, _maquina);
        this.condicionEnlace = new CondicionEnlace();
        this.arrow = new Arrow();
        this.setExtremos();
        this.setIconValue(5);
        this.orientacion = _orientacion;
    }

    public void setPoints() {
        this.setExtremos();
    }

    public void setExtremos() {
        Rectangle2D rect1 = Maquina.FONT_TRI25.getStringBounds(this.previa.getNombre(), new FontRenderContext(Maquina.FONT_TRI25.getTransform(), true, true));
        this.w = (int)rect1.getWidth();
        this.h = (int)rect1.getHeight();
        switch (this.orientacion) {
            case 0: {
                this.x0 = this.previa.x0 + this.w + 10;
                this.y0 = this.previa.y0 - this.h / 2 + 10;
                this.x1 = this.previa.x0 - 10;
                this.y1 = this.previa.y0 - 45;
                this.alpha = (int)(Math.atan((this.y0 - this.y1) / this.w) * 180.0 / Math.PI);
                this.beta = 180 - 2 * this.alpha;
                break;
            }
            case 1: {
                this.x0 = this.previa.x0 + this.w + 10;
                this.y0 = this.previa.y0 + 30;
                this.x1 = this.w + 2 * this.previa.x0 - this.x0;
                this.y1 = this.previa.y0 - this.h / 2 + 3;
                this.alpha = (int)(Math.atan((this.y0 - this.y1) / this.w) * 180.0 / Math.PI);
                this.beta = 180 - 2 * this.alpha;
                break;
            }
            case 2: {
                this.h -= 10;
                this.x0 = this.previa.x0 + this.w / 2 + 35;
                this.y0 = this.previa.y0 + 10;
                this.x1 = this.w / 2 + this.previa.x0;
                this.y1 = this.previa.y0 - this.h - 10;
                this.alpha = (int)(Math.atan((this.x0 - this.x1) / this.h) * 180.0 / Math.PI);
                this.beta = 180 - 2 * this.alpha;
                break;
            }
            case 3: {
                this.h -= 10;
                this.x0 = this.previa.x0 + this.w / 2;
                this.y0 = this.previa.y0 + 10;
                this.x1 = this.w / 2 + this.previa.x0 - 35;
                this.y1 = this.previa.y0 - this.h - 10;
                this.alpha = (int)(Math.atan((this.x0 - this.x1) / this.h) * 180.0 / Math.PI);
                this.beta = 180 - 2 * this.alpha;
            }
        }
    }

    public void dibujar(Graphics g) {
        if (Maquina.selectedMachine != null && this == Maquina.selectedMachine) {
            g.setColor(Color.magenta);
        } else if (JTV.searchedMachine != null && this == JTV.searchedMachine) {
            g.setColor(Color.pink);
        } else if (Maquina.playMachine != null && this == Maquina.playMachine) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.black);
        }
        g.setFont(Enlace.FONT_TRI10);
        this.setExtremos();
        Rectangle2D rect = null;
        switch (this.orientacion) {
            case 0: {
                g.drawArc(this.x1, this.y1, this.x0 - this.x1, this.y0 - this.y1, -this.alpha, 360 - this.beta);
                this.arrow.drawArrow(g, this.previa.x0 + this.w + 1, this.y0 - 1, this.previa.x0 + this.w, this.y0 - 1);
                this.condicionEnlace.setOperandos();
                rect = this.condicionEnlace.getStringBounds();
                this.condicionEnlace.x0 = (this.x0 + this.x1) / 2 - (int)rect.getWidth() / 2;
                this.condicionEnlace.y0 = this.y1 - (this.y0 - this.y1) / 4 + 7;
                this.condicionEnlace.dibujar(g);
                break;
            }
            case 1: {
                g.drawArc(this.x1, this.y1, this.x0 - this.x1, this.y0 - this.y1, this.alpha + this.beta, 360 - this.beta);
                this.arrow.drawArrow(g, this.previa.x0 + this.w + 1, this.y1 + 1, this.previa.x0 + this.w, this.y1);
                this.condicionEnlace.setOperandos();
                rect = this.condicionEnlace.getStringBounds();
                this.condicionEnlace.x0 = (this.x0 + this.x1) / 2 - (int)rect.getWidth() / 2;
                this.condicionEnlace.y0 = this.y0 + (this.y0 - this.y1) / 4 + 5;
                this.condicionEnlace.dibujar(g);
                break;
            }
            case 2: {
                g.drawArc(this.x1, this.y1, this.x0 - this.x1, this.y0 - this.y1, 270 - this.alpha, 360 - this.beta);
                this.arrow.drawArrow(g, this.previa.x0 + this.w / 2 + 1, this.previa.y0 - this.h - 1, this.previa.x0 + this.w / 2, this.previa.y0 - this.h);
                this.condicionEnlace.setOperandos();
                rect = this.condicionEnlace.getStringBounds();
                this.condicionEnlace.x0 = this.x0 + 5;
                this.condicionEnlace.y0 = (this.y0 + this.y1) / 2 + (int)rect.getHeight() / 2;
                this.condicionEnlace.dibujar(g);
                break;
            }
            case 3: {
                g.drawArc(this.x1, this.y1, this.x0 - this.x1, this.y0 - this.y1, 90 - this.alpha, 360 - this.beta);
                this.arrow.drawArrow(g, this.previa.x0 + this.w / 2 - 1, this.previa.y0 - this.h - 1, this.previa.x0 + this.w / 2, this.previa.y0 - this.h);
                this.condicionEnlace.setOperandos();
                rect = this.condicionEnlace.getStringBounds();
                this.condicionEnlace.x0 = this.x1 - (int)rect.getWidth() - 2;
                this.condicionEnlace.y0 = (this.y0 + this.y1) / 2 + (int)rect.getHeight() / 2;
                this.condicionEnlace.dibujar(g);
            }
        }
    }

    public boolean isMouseClicked(int x, int y) {
        switch (this.orientacion) {
            case 0: {
                if (!new Arc2D.Double(this.x1, this.y1, this.x0 - this.x1, this.y0 - this.y1, -this.alpha, 360 - this.beta, 0).intersects(x, y, 3.0, 3.0)) break;
                return true;
            }
            case 1: {
                if (!new Arc2D.Double(this.x1, this.y1, this.x0 - this.x1, this.y0 - this.y1, this.alpha + this.beta, 360 - this.beta, 0).intersects(x, y, 3.0, 3.0)) break;
                return true;
            }
            case 2: {
                if (!new Arc2D.Double(this.x1, this.y1, this.x0 - this.x1, this.y0 - this.y1, 270 - this.alpha, 360 - this.beta, 0).intersects(x, y, 3.0, 3.0)) break;
                return true;
            }
            case 3: {
                if (!new Arc2D.Double(this.x1, this.y1, this.x0 - this.x1, this.y0 - this.y1, 90 - this.alpha, 360 - this.beta, 0).intersects(x, y, 3.0, 3.0)) break;
                return true;
            }
        }
        return false;
    }

    public void mover(int dx, int dy) {
    }

    public void moverPrevia(int dx, int dy) {
    }

    public void moverProxima(int dx, int dy) {
    }

    public void moveRewind() {
    }

    public void moveForward() {
    }

    public int getOrientacion() {
        return this.orientacion;
    }

    public void setOrientacion(int orientacion) {
        this.orientacion = orientacion;
    }

    public int showDialog(int numOfTapes, boolean addComando) {
        DialogAutoenlace dv = new DialogAutoenlace(new JFrame(), true, numOfTapes, this, addComando);
        dv.setSize(400, 400);
        dv.setVisible(true);
        return dv.getReturnStatus();
    }

    public String getXML() {
        Integer indexCinta;
        String xml = "";
        xml = xml + "<auto-enlace \n";
        xml = xml + "    id=\"" + this.idMaquina + "\"\n";
        xml = xml + "    id-previa=\"" + this.previa.idMaquina + "\"\n";
        xml = xml + "    id-proxima=\"" + this.proxima.idMaquina + "\"\n";
        xml = xml + "    orientacion=\"" + this.orientacion + "\"\n";
        if (this.condicionEnlace.operandosDerecho.size() == 0 && this.condicionEnlace.operandosIzquierdo.size() == 0) {
            xml = xml + "/>\n\n";
            return xml;
        }
        xml = xml + ">\n\n";
        Enumeration en = this.condicionEnlace.operandosDerecho.keys();
        while (en.hasMoreElements()) {
            indexCinta = (Integer)en.nextElement();
            Vector operandosDerecho = (Vector)this.condicionEnlace.operandosDerecho.get(indexCinta);
            xml = xml + "    <condicion cinta=\"" + indexCinta + "\" not=\"" + ((Boolean)this.condicionEnlace.operandosNots.get(indexCinta)).toString() + "\"";
            if (this.condicionEnlace.operandosIzquierdo.containsKey(indexCinta)) {
                String operandoIzquierdo = (String)this.condicionEnlace.operandosIzquierdo.get(indexCinta);
                xml = xml + " operando-izquierdo=\"" + Hellada.symbol2XML(operandoIzquierdo) + "\"";
            }
            if (operandosDerecho.size() == 0) {
                xml = xml + "/>\n";
                continue;
            }
            xml = xml + ">\n";
            Enumeration en2 = operandosDerecho.elements();
            while (en2.hasMoreElements()) {
                String operandoDerecho = (String)en2.nextElement();
                xml = xml + "          <operando-derecho nombre=\"" + Hellada.symbol2XML(operandoDerecho) + "\"/>\n";
            }
            xml = xml + "     </condicion>\n";
        }
        en = null;
        en = this.condicionEnlace.operandosIzquierdo.keys();
        while (en.hasMoreElements()) {
            indexCinta = (Integer)en.nextElement();
            if (this.condicionEnlace.operandosDerecho.containsKey(indexCinta)) continue;
            String operandoIzquierdo = (String)this.condicionEnlace.operandosIzquierdo.get(indexCinta);
            xml = xml + "     <condicion cinta=\"" + indexCinta + "\" not=\"" + ((Boolean)this.condicionEnlace.operandosNots.get(indexCinta)).toString() + "\"";
            xml = xml + " operando-izquierdo=\"" + Hellada.symbol2XML(operandoIzquierdo) + "\"/>\n";
        }
        xml = xml + "</auto-enlace>\n";
        return xml;
    }
}

