/*
 * Decompiled with CFR 0.152.
 */
package cl.jtv;

import cl.jtv.DialogParametros;
import cl.jtv.EnlaceCompuesto;
import cl.jtv.JTV;
import cl.jtv.LHD;
import cl.jtv.Maquina;
import cl.jtv.NodeTreeTrace;
import cl.jtv.Parametro;
import cl.jtv.RHD;
import cl.jtv.Vector2;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JFrame;

public class Submaquina
extends Maquina {
    protected String nombreLargo;
    protected String nombreCorto;
    protected String descripcion;
    Maquina submaquina;
    Vector machineComponents;
    NodeTreeTrace rootTreeTrace;
    Hashtable variables;
    Hashtable parametros;
    private boolean not;
    private boolean monocinta;

    public Submaquina(int x, int y, int c, Maquina prev, Maquina prox) {
        super(x, y, c, prev, prox);
        this.setIconValue(10);
        this.setNombre("M");
        this.variables = new Hashtable();
        this.parametros = new Hashtable();
        this.machineComponents = null;
    }

    public String getDescripcion() {
        return this.descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public String getNombreCorto() {
        if (this.machineComponents == null) {
            return this.nombreCorto;
        }
        return ((Vector2)this.machineComponents).getNombreCorto();
    }

    public void setNombreCorto(String nombreCorto) {
    }

    public String getNombreLargo() {
        if (this.machineComponents == null) {
            return this.nombreLargo;
        }
        return ((Vector2)this.machineComponents).getNombreLargo();
    }

    public void setNombreLargo(String nombreLargo) {
        this.nombreLargo = nombreLargo;
    }

    public void dibujar(Graphics g) {
        if (Maquina.selectedMachine != null && this == Maquina.selectedMachine) {
            g.setColor(Color.magenta);
        } else if (JTV.searchedMachine != null && this == JTV.searchedMachine) {
            g.setColor(Color.pink);
        } else if (Maquina.playMachine != null && this == Maquina.playMachine) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.black);
        }
        g.setFont(Maquina.FONT_TRI25);
        if (!Maquina.oldNotation && this.getNombre().equals("L")) {
            LHD.dibujar(g, this.x0, this.y0);
        } else if (!Maquina.oldNotation && this.getNombre().equals("R")) {
            RHD.dibujar(g, this.x0, this.y0);
        } else {
            g.drawString(this.getNombre(), this.x0, this.y0);
        }
        if (this.isInicial()) {
            g.drawString(">", this.x0 - (int)Maquina.RECT_INICIAL.getWidth(), this.y0);
        }
        g.setFont(Maquina.FONT_AP8);
        Rectangle2D rect1 = Maquina.FONT_TRI25.getStringBounds(this.getNombre(), new FontRenderContext(Maquina.FONT_TRI25.getTransform(), true, true));
        if (this.getNombreCorto() != null) {
            Rectangle2D rect2 = Maquina.FONT_AP8.getStringBounds(this.getNombreCorto(), new FontRenderContext(Maquina.FONT_AP8.getTransform(), true, true));
            g.drawString(this.getNombreCorto(), (int)((double)this.x0 - Math.abs(rect1.getX() - rect2.getX()) / 2.0), (int)((double)this.y0 - rect2.getY() + 2.0));
        }
        Set en = this.parametros.keySet();
        ArrayList list = new ArrayList(en);
        Collections.sort(list);
        Iterator iter = list.iterator();
        String stringParametros = "";
        try {
            while (iter.hasNext()) {
                stringParametros = stringParametros + ((Parametro)this.parametros.get(iter.next())).getNombre() + ",";
            }
        }
        catch (Exception ex) {
            System.out.println("Excepcion");
        }
        if (stringParametros.length() > 0) {
            stringParametros = stringParametros.substring(0, stringParametros.length() - 1);
        }
        Rectangle2D rect3 = Maquina.FONT_TRI14.getStringBounds(stringParametros, new FontRenderContext(Maquina.FONT_TRP13.getTransform(), true, true));
        g.setFont(Maquina.FONT_TRI14);
        if (this.isNot()) {
            g.drawLine(this.x0 + (int)rect1.getWidth(), this.y0 - 2, this.x0 + (int)rect1.getWidth() + (int)rect3.getWidth(), this.y0 - 2);
        }
        g.drawString(stringParametros, this.x0 + (int)rect1.getWidth() + 2, this.y0 + (int)rect3.getHeight() - 7);
        if (Maquina.displayIndex) {
            g.setFont(Maquina.FONT_TRP13);
            g.drawString("(" + (this.getIndiceCinta() + 1) + ")", this.x0 + (this.monocinta ? 1 : 2) * 10, this.y0 - 15);
        }
        super.dibujar(g);
    }

    public boolean isNot() {
        return this.not;
    }

    public void setNot(boolean not) {
        this.not = not;
    }

    public boolean isMonocinta() {
        return this.monocinta;
    }

    public void setMonocinta(boolean monocinta) {
        this.monocinta = monocinta;
    }

    public void refreshParametros(boolean move) {
        String parametro;
        if (this.monocinta) {
            return;
        }
        Vector vectorParametros = ((Vector2)this.machineComponents).getParametros();
        Enumeration<Object> en = vectorParametros.elements();
        while (en.hasMoreElements()) {
            parametro = (String)en.nextElement();
            if (this.parametros.containsKey(parametro)) continue;
            this.parametros.put(parametro, new Parametro(parametro));
            if (!move || this.proxima == null || this.proxima instanceof EnlaceCompuesto) continue;
            this.proxima.moveForward3(13);
        }
        en = null;
        en = ((Hashtable)this.parametros.clone()).keys();
        while (en.hasMoreElements()) {
            parametro = (String)en.nextElement();
            if (vectorParametros.contains(parametro)) continue;
            this.parametros.remove(parametro);
            if (!move || this.proxima == null || this.proxima instanceof EnlaceCompuesto) continue;
            this.proxima.moveForward3(-13);
        }
    }

    public int showDialog(int numOfTapes, boolean addComando) {
        if (this.getNombre().equals("S")) {
            return 0;
        }
        DialogParametros dv = new DialogParametros((Frame)new JFrame(), true, this, addComando);
        dv.setVisible(true);
        return dv.getReturnStatus();
    }

    public int getDelta() {
        if (this.parametros.size() == 0) {
            return 20;
        }
        return 20 + this.parametros.size() * 13;
    }

    public String getXML() {
        String xml = "";
        String tail = "/>\n\n";
        String tag = "";
        boolean param = false;
        if (this.nombre.equals("M")) {
            xml = xml + "<submaquina\n";
            tag = "</submaquina>\n";
            param = true;
        } else if (this.nombre.equals("L") && !this.not) {
            xml = xml + "<buscadora-L\n";
            tag = "</buscadora-L>\n";
            param = true;
        } else if (this.nombre.equals("L") && this.not) {
            xml = xml + "<buscadora-L-NOT\n";
            tag = "</buscadora-L-NOT>\n";
            param = true;
        } else if (this.nombre.equals("R") && !this.not) {
            xml = xml + "<buscadora-R\n";
            tag = "</buscadora-R>\n";
            param = true;
        } else if (this.nombre.equals("R") && this.not) {
            xml = xml + "<buscadora-R-NOT\n";
            tag = "</buscadora-R-NOT>\n";
            param = true;
        } else if (this.nombre.equals("S") && this.parametros.containsKey("L")) {
            xml = xml + "<SL\n";
        } else if (this.nombre.equals("S") && this.parametros.containsKey("R")) {
            xml = xml + "<SR\n";
        }
        try {
            if (param) {
                Enumeration en = this.parametros.keys();
                tail = ">\n";
                while (en.hasMoreElements()) {
                    String nombreParametro = (String)en.nextElement();
                    Parametro parametro = (Parametro)this.parametros.get(nombreParametro);
                    if (parametro.isSet()) {
                        tail = tail + "   <parametro nombre=\"" + nombreParametro + "\" valor=\"" + parametro.getNombre() + "\"/>\n";
                        continue;
                    }
                    tail = tail + "   <parametro nombre=\"" + nombreParametro + "\" valor=\"" + "INDEFINIDO" + "\"/>\n";
                }
                tail = tail + tag;
            }
        }
        catch (Exception ex) {
            System.out.println("Excepci\u00f3n");
        }
        xml = xml + "    nombre-repositorio=\"" + this.getNombreLargo() + "\"\n";
        xml = xml + "    id=\"" + this.idMaquina + "\"\n";
        xml = xml + "    id-previa=\"" + (this.previa == null ? "null" : Integer.toString(this.previa.idMaquina)) + "\"\n";
        xml = xml + "    id-proxima=\"" + (this.proxima == null ? "null" : Integer.toString(this.proxima.idMaquina)) + "\"\n";
        xml = xml + "    x=\"" + this.x0 + "\"\n";
        xml = xml + "    y=\"" + this.y0 + "\"\n";
        xml = xml + "    cinta=\"" + this.getIndiceCinta() + "\"\n";
        xml = xml + "    inicial=\"" + this.isInicial() + "\"\n";
        xml = xml + tail;
        return xml;
    }

    public String getLatex(int maxCintas) {
        return "";
    }
}

