/*
 * Decompiled with CFR 0.152.
 */
package cl.jtv;

import cl.jtv.AutoEnlace;
import cl.jtv.Cinta;
import cl.jtv.Comando;
import cl.jtv.ComandoEM;
import cl.jtv.ComandoEPRX;
import cl.jtv.ComandoIE;
import cl.jtv.DiccionarioMetavalores;
import cl.jtv.Enlace;
import cl.jtv.EnlaceCompuesto;
import cl.jtv.JTV;
import cl.jtv.Utils;
import cl.jtv.Vector2;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JScrollPane;

public abstract class Maquina
implements Cloneable {
    public static int idContador = 0;
    public static int indexStateCounter = 0;
    public static boolean displayIndex = true;
    public static boolean flagUR = false;
    public int idMaquina;
    public int indexStateMaquina;
    int x0;
    int y0;
    Cinta cinta;
    private int indiceCinta;
    Maquina previa;
    Maquina proxima;
    public static Maquina playMachine;
    public static Maquina selectedMachine;
    public static boolean oldNotation;
    public static boolean running;
    protected int iconValue;
    protected String nombre;
    protected Rectangle boundRectangle;
    protected Rectangle leftRectangle;
    protected Rectangle rightRectangle;
    protected boolean inicial;
    static final Font FONT_TRI30;
    static final Font FONT_TRI25;
    static final Font FONT_TRI20;
    static final Font FONT_TRP19;
    static final Font FONT_TRI16;
    static final Font FONT_TRP16;
    static final Font FONT_TRI14;
    static final Font FONT_TRP13;
    static final Font FONT_TRI13;
    static final Font FONT_TRP10;
    static final Font FONT_AP13;
    static final Font FONT_AP10;
    static final Font FONT_AP8;
    static final Font FONT_AP7;
    static final String SIMBOLO_INICIAL = ">";
    static final Rectangle2D RECT_INICIAL;
    static final int delta_x = 10;
    static final int delta_y = 15;
    static final int ESTADO_DORMIDA = 0;
    static final int ESTADO_COLGADA = 1;
    static final int ESTADO_VAR_NO_SET = 2;
    static final int ESTADO_PAR_NO_SET = 3;
    static final int ESTADO_HALT = 4;
    static final int ESTADO_ND = 5;
    static final int ESTADO_EXPANDIBLE = 6;
    static final int ESTADO_RECHAZA = 7;
    static boolean dibujaRecursivo;

    Maquina(int x, int y, Cinta c, Maquina prev, Maquina prox) {
        this.x0 = x;
        this.y0 = y;
        this.cinta = c;
        this.previa = prev;
        this.proxima = prox;
        this.idMaquina = ++idContador;
    }

    Maquina(Cinta c, Maquina prev, Maquina prox) {
        this.cinta = c;
        this.previa = prev;
        this.proxima = prox;
        this.idMaquina = ++idContador;
    }

    Maquina(int x, int y, int _indiceCinta, Maquina _previa, Maquina _proxima) {
        this.x0 = x;
        this.y0 = y;
        this.indiceCinta = _indiceCinta;
        this.previa = _previa;
        this.proxima = _proxima;
        this.idMaquina = ++idContador;
    }

    Maquina(int x, int y) {
        this.x0 = x;
        this.y0 = y;
        this.idMaquina = ++idContador;
    }

    Maquina() {
        this.y0 = 0;
        this.x0 = 0;
        this.cinta = null;
        this.proxima = null;
        this.previa = null;
        this.idMaquina = ++idContador;
    }

    public void accion() {
        if (this.proxima != null) {
            this.proxima.accion();
        }
    }

    public void accion(Cinta _cinta) {
    }

    public boolean accion(Cinta[] _arrayOfTapes, DiccionarioMetavalores dicMetavalores) {
        return true;
    }

    public void dibujar(Graphics g) {
        if (this.proxima != null && dibujaRecursivo) {
            this.proxima.dibujar(g);
        }
    }

    public void setCinta(Cinta _cinta) {
        this.cinta = _cinta;
    }

    public Cinta getCinta() {
        return this.cinta;
    }

    public void setIndiceCinta(int _indiceCinta) {
        this.indiceCinta = _indiceCinta;
    }

    public int getIndiceCinta() {
        return this.indiceCinta;
    }

    public int getMaxIndiceCinta() {
        return this.indiceCinta;
    }

    public void setPrevMaquina(Maquina _previa) {
        this.previa = _previa;
    }

    public void setProxMaquina(Maquina _proxima) {
        this.proxima = _proxima;
    }

    public void setIconValue(int _iconValue) {
        this.iconValue = _iconValue;
    }

    public int getIconValue() {
        return this.iconValue;
    }

    public void setNombre(String _nombre) {
        this.nombre = _nombre;
        Rectangle2D rect = this.getBounds();
        this.boundRectangle = new Rectangle(this.x0, this.y0 - (int)Math.abs(0.8 * rect.getHeight()), (int)Math.abs(rect.getWidth()), (int)Math.abs(0.8 * rect.getHeight()));
        this.leftRectangle = new Rectangle(this.x0, this.y0 - (int)Math.abs(0.8 * rect.getHeight()), (int)Math.abs(0.5 * rect.getWidth()) + 2, (int)Math.abs(0.8 * rect.getHeight()));
        this.rightRectangle = new Rectangle(this.x0 + (int)Math.abs(0.5 * rect.getWidth()), this.y0 - (int)Math.abs(0.8 * rect.getHeight()), (int)Math.abs(0.5 * rect.getWidth()) + 2, (int)Math.abs(0.8 * rect.getHeight()));
    }

    public String getNombre() {
        return this.nombre;
    }

    public Rectangle2D getBounds() {
        return FONT_TRI25.getStringBounds(this.getNombre(), new FontRenderContext(FONT_TRI25.getTransform(), true, true));
    }

    public boolean esInicial() {
        return this.previa == null && this.proxima != null;
    }

    public boolean esEnlazable() {
        return true;
    }

    public boolean isMouseClicked(int x, int y) {
        return false;
    }

    public void insertMachine(Maquina newMachine, boolean leftInsert, Vector repository) {
        if (leftInsert) {
            Maquina oldPrevia = this.previa;
            this.setPrevMaquina(newMachine);
            newMachine.setProxMaquina(this);
            if (oldPrevia != null) {
                oldPrevia.setProxMaquina(newMachine);
                newMachine.setPrevMaquina(oldPrevia);
            }
            newMachine.moveRewind(newMachine.getDelta());
            if (this.isInicial()) {
                this.setInicial(false);
                newMachine.setInicial(true);
                ((Vector2)repository).inicial = newMachine;
            }
        } else {
            Maquina oldProxima = this.proxima;
            if (!(oldProxima instanceof EnlaceCompuesto)) {
                this.setProxMaquina(newMachine);
                newMachine.setPrevMaquina(this);
                if (oldProxima != null) {
                    newMachine.setProxMaquina(oldProxima);
                    oldProxima.setPrevMaquina(newMachine);
                }
                newMachine.moveForward(this.getDelta());
            } else {
                this.setProxMaquina(newMachine);
                newMachine.setPrevMaquina(this);
                newMachine.setProxMaquina(oldProxima);
                oldProxima.setPrevMaquina(newMachine);
                Enumeration en = ((EnlaceCompuesto)oldProxima).getEnlaces();
                while (en.hasMoreElements()) {
                    Enlace enlace = (Enlace)en.nextElement();
                    enlace.setPrevMaquina(newMachine);
                }
                for (int i = 0; i < repository.size(); ++i) {
                    if (!(repository.get(i) instanceof Enlace) || ((Maquina)repository.get((int)i)).proxima != this) continue;
                    ((Enlace)repository.get(i)).setProxMaquina(newMachine);
                }
                newMachine.moveForward(this.getDelta());
            }
        }
        repository.add(newMachine);
    }

    public void deleteMachine(Vector repository) {
        if (this.previa != null && this.proxima != null && !(this.proxima instanceof EnlaceCompuesto)) {
            this.previa.setProxMaquina(this.proxima);
            this.proxima.setPrevMaquina(this.previa);
            this.previa.moveForward2(this.getDelta());
            Comando comando = Comando.getLastComando();
            Comando inverse = comando.getInverse();
            for (int i = 0; i < repository.size(); ++i) {
                if (!(repository.get(i) instanceof Enlace) || ((Maquina)repository.get((int)i)).proxima != this) continue;
                ((Enlace)repository.get(i)).setProxMaquina(this.proxima);
                if (!Comando.flagDelete) continue;
                comando.addComando(new ComandoEPRX(repository.get(i), (Vector2)repository, this.proxima));
                inverse.addComando(new ComandoEPRX(repository.get(i), (Vector2)repository, this));
            }
            repository.remove(this);
            return;
        }
        if (this.previa != null && this.proxima instanceof EnlaceCompuesto) {
            this.previa.setProxMaquina(this.proxima);
            this.previa.moveForward2(this.getDelta());
            Enumeration enlaces = ((EnlaceCompuesto)this.proxima).getEnlaces();
            while (enlaces.hasMoreElements()) {
                Enlace enlace = (Enlace)enlaces.nextElement();
                enlace.setPrevMaquina(this.previa);
                if (!(enlace instanceof AutoEnlace)) continue;
                enlace.setProxMaquina(this.previa);
            }
            Comando comando = Comando.getLastComando();
            Comando inverse = comando.getInverse();
            for (int i = 0; i < repository.size(); ++i) {
                if (!(repository.get(i) instanceof Enlace) || ((Maquina)repository.get((int)i)).proxima != this) continue;
                ((Enlace)repository.get(i)).setProxMaquina(this.previa);
                if (!Comando.flagDelete) continue;
                comando.addComando(new ComandoEPRX(repository.get(i), (Vector2)repository, this.previa));
                inverse.addComando(new ComandoEPRX(repository.get(i), (Vector2)repository, this));
            }
            repository.remove(this);
            return;
        }
        if (this.previa != null && this.proxima == null) {
            this.previa.setProxMaquina(this.proxima);
            this.previa.moveForward2(this.getDelta());
            Comando comando = Comando.getLastComando();
            Comando inverse = comando.getInverse();
            for (int i = 0; i < repository.size(); ++i) {
                if (!(repository.get(i) instanceof Enlace) || ((Maquina)repository.get((int)i)).proxima != this) continue;
                ((Enlace)repository.get(i)).setProxMaquina(this.previa);
                if (!Comando.flagDelete) continue;
                comando.addComando(new ComandoEPRX(repository.get(i), (Vector2)repository, this.previa));
                inverse.addComando(new ComandoEPRX(repository.get(i), (Vector2)repository, this));
            }
            repository.remove(this);
            return;
        }
        if (this.previa == null && this.proxima instanceof EnlaceCompuesto) {
            Enumeration enlaces = ((EnlaceCompuesto)this.proxima).getEnlaces();
            Vector<Enlace> enlacesRemovidos = new Vector<Enlace>();
            while (enlaces.hasMoreElements()) {
                Enlace enlace = (Enlace)enlaces.nextElement();
                enlacesRemovidos.add(enlace);
                enlace = null;
            }
            for (int i = 0; i < repository.size(); ++i) {
                if (!(repository.get(i) instanceof Enlace) || repository.get(i) instanceof AutoEnlace || ((Maquina)repository.get((int)i)).proxima != this) continue;
                enlacesRemovidos.add((Enlace)repository.get(i));
            }
            Comando comando = Comando.getLastComando();
            Comando inverse = comando.getInverse();
            Enumeration enRem = enlacesRemovidos.elements();
            while (enRem.hasMoreElements()) {
                Enlace enlace = (Enlace)enRem.nextElement();
                enlace.deleteMachine(repository);
                if (!Comando.flagDelete) continue;
                comando.addComando(new ComandoEM(enlace, (Vector2)repository));
                inverse.addComando(new ComandoIE(enlace, (Vector2)repository));
            }
            this.proxima = null;
            repository.remove(this);
            return;
        }
        if (this.previa == null && this.proxima != null && !(this.proxima instanceof EnlaceCompuesto)) {
            this.proxima.setPrevMaquina(null);
            Comando comando = Comando.getLastComando();
            Comando inverse = comando.getInverse();
            for (int i = 0; i < repository.size(); ++i) {
                if (!(repository.get(i) instanceof Enlace) || ((Maquina)repository.get((int)i)).proxima != this) continue;
                ((Enlace)repository.get(i)).setProxMaquina(this.proxima);
                if (!Comando.flagDelete) continue;
                comando.addComando(new ComandoEPRX(repository.get(i), (Vector2)repository, this.proxima));
                inverse.addComando(new ComandoEPRX(repository.get(i), (Vector2)repository, this));
            }
            repository.remove(this);
            if (this.isInicial()) {
                this.setInicial(false);
                this.proxima.setInicial(true);
                ((Vector2)repository).inicial = this.proxima;
            }
            return;
        }
        if (this.previa == null && this.proxima == null) {
            Vector enlacesRemovidos = new Vector();
            for (int i = 0; i < repository.size(); ++i) {
                if (!(repository.get(i) instanceof Enlace) || ((Maquina)repository.get((int)i)).proxima != this) continue;
                enlacesRemovidos.add(repository.get(i));
            }
            Comando comando = Comando.getLastComando();
            Comando inverse = comando.getInverse();
            Enumeration enRem = enlacesRemovidos.elements();
            while (enRem.hasMoreElements()) {
                Enlace enlace = (Enlace)enRem.nextElement();
                enlace.deleteMachine(repository);
                if (!Comando.flagDelete) continue;
                comando.addComando(new ComandoEM(enlace, (Vector2)repository));
                inverse.addComando(new ComandoIE(enlace, (Vector2)repository));
            }
            repository.remove(this);
        }
    }

    public void moveForward2() {
        if (flagUR) {
            return;
        }
        int delta = this.getDelta();
        this.x0 += delta;
        this.boundRectangle.setLocation((int)this.boundRectangle.getX() + delta, (int)this.boundRectangle.getY());
        this.leftRectangle.setLocation((int)this.leftRectangle.getX() + delta, (int)this.boundRectangle.getY());
        this.rightRectangle.setLocation((int)this.rightRectangle.getX() + delta, (int)this.rightRectangle.getY());
        if (this.previa != null) {
            this.previa.moveForward2(delta);
        }
    }

    public void moveForward2(int delta) {
        if (flagUR) {
            return;
        }
        this.x0 += delta;
        this.boundRectangle.setLocation((int)this.boundRectangle.getX() + delta, (int)this.boundRectangle.getY());
        this.leftRectangle.setLocation((int)this.leftRectangle.getX() + delta, (int)this.boundRectangle.getY());
        this.rightRectangle.setLocation((int)this.rightRectangle.getX() + delta, (int)this.rightRectangle.getY());
        if (this.previa != null) {
            this.previa.moveForward2(delta);
        }
    }

    public void moveForward() {
        if (flagUR) {
            return;
        }
        int delta = this.getDelta();
        this.x0 += delta;
        this.boundRectangle.setLocation((int)this.boundRectangle.getX() + delta, (int)this.boundRectangle.getY());
        this.leftRectangle.setLocation((int)this.leftRectangle.getX() + delta, (int)this.boundRectangle.getY());
        this.rightRectangle.setLocation((int)this.rightRectangle.getX() + delta, (int)this.rightRectangle.getY());
        if (this.proxima != null && !(this.proxima instanceof EnlaceCompuesto)) {
            this.proxima.moveForward(delta);
        }
    }

    public void moveForward(int delta) {
        if (flagUR) {
            return;
        }
        this.x0 += delta;
        this.boundRectangle.setLocation((int)this.boundRectangle.getX() + delta, (int)this.boundRectangle.getY());
        this.leftRectangle.setLocation((int)this.leftRectangle.getX() + delta, (int)this.boundRectangle.getY());
        this.rightRectangle.setLocation((int)this.rightRectangle.getX() + delta, (int)this.rightRectangle.getY());
        if (this.proxima != null && !(this.proxima instanceof EnlaceCompuesto)) {
            this.proxima.moveForward3(this.getDelta());
        }
    }

    public void moveForward3(int delta) {
        if (flagUR) {
            return;
        }
        this.x0 += delta;
        this.boundRectangle.setLocation((int)this.boundRectangle.getX() + delta, (int)this.boundRectangle.getY());
        this.leftRectangle.setLocation((int)this.leftRectangle.getX() + delta, (int)this.boundRectangle.getY());
        this.rightRectangle.setLocation((int)this.rightRectangle.getX() + delta, (int)this.rightRectangle.getY());
        if (this.proxima != null && !(this.proxima instanceof EnlaceCompuesto)) {
            this.proxima.moveForward3(delta);
        }
    }

    public void moveRewind() {
        if (flagUR) {
            return;
        }
        int delta = this.getDelta();
        this.x0 -= delta;
        this.boundRectangle.setLocation((int)this.boundRectangle.getX() - delta, (int)this.boundRectangle.getY());
        this.leftRectangle.setLocation((int)this.leftRectangle.getX() - delta, (int)this.boundRectangle.getY());
        this.rightRectangle.setLocation((int)this.rightRectangle.getX() - delta, (int)this.rightRectangle.getY());
        if (this.previa != null) {
            this.previa.moveRewind(delta);
        }
    }

    public void moveRewind(int delta) {
        if (flagUR) {
            return;
        }
        this.x0 -= delta;
        this.boundRectangle.setLocation((int)this.boundRectangle.getX() - delta, (int)this.boundRectangle.getY());
        this.leftRectangle.setLocation((int)this.leftRectangle.getX() - delta, (int)this.boundRectangle.getY());
        this.rightRectangle.setLocation((int)this.rightRectangle.getX() - delta, (int)this.rightRectangle.getY());
        if (this.previa != null) {
            this.previa.moveRewind(delta);
        }
    }

    public void mover(int dx, int dy) {
        this.x0 += dx;
        this.y0 += dy;
        this.boundRectangle.setLocation((int)this.boundRectangle.getX() + dx, (int)this.boundRectangle.getY() + dy);
        this.leftRectangle.setLocation((int)this.leftRectangle.getX() + dx, (int)this.boundRectangle.getY() + dy);
        this.rightRectangle.setLocation((int)this.rightRectangle.getX() + dx, (int)this.rightRectangle.getY() + dy);
        if (this.previa != null) {
            this.previa.moverPrevia(dx, dy);
        }
        if (this.proxima != null) {
            this.proxima.moverProxima(dx, dy);
        }
    }

    public void moverPrevia(int dx, int dy) {
        this.x0 += dx;
        this.y0 += dy;
        this.boundRectangle.setLocation((int)this.boundRectangle.getX() + dx, (int)this.boundRectangle.getY() + dy);
        this.leftRectangle.setLocation((int)this.leftRectangle.getX() + dx, (int)this.boundRectangle.getY() + dy);
        this.rightRectangle.setLocation((int)this.rightRectangle.getX() + dx, (int)this.rightRectangle.getY() + dy);
        if (this.previa != null) {
            this.previa.moverPrevia(dx, dy);
        }
    }

    public void moverProxima(int dx, int dy) {
        this.x0 += dx;
        this.y0 += dy;
        this.boundRectangle.setLocation((int)this.boundRectangle.getX() + dx, (int)this.boundRectangle.getY() + dy);
        this.leftRectangle.setLocation((int)this.leftRectangle.getX() + dx, (int)this.boundRectangle.getY() + dy);
        this.rightRectangle.setLocation((int)this.rightRectangle.getX() + dx, (int)this.rightRectangle.getY() + dy);
        if (this.proxima != null) {
            this.proxima.moverProxima(dx, dy);
        }
    }

    public void updateBounds() {
        Rectangle2D rect = this.getBounds();
        this.boundRectangle.setLocation(this.x0, this.y0 - (int)Math.abs(0.8 * rect.getHeight()));
        this.leftRectangle.setLocation(this.x0, this.y0 - (int)Math.abs(0.8 * rect.getHeight()));
        this.rightRectangle.setLocation(this.x0 + (int)Math.abs(0.5 * rect.getWidth()), this.y0 - (int)Math.abs(0.8 * rect.getHeight()));
    }

    public void getAttributes(int x, int y) {
    }

    public int showDialog(int numOfTapes, boolean addComando) {
        return 0;
    }

    public boolean isInicial() {
        return this.inicial;
    }

    public void setInicial(boolean newInicial) {
        this.inicial = newInicial;
    }

    public int getDelta() {
        return 20;
    }

    public abstract String getXML();

    public void setScrollBars(JScrollPane scrollPane) {
        int h = scrollPane.getHorizontalScrollBar().getModel().getValue();
        int v = scrollPane.getVerticalScrollBar().getModel().getValue();
        Rectangle rect = scrollPane.getViewportBorderBounds();
        rect.setLocation(h, v);
        if (rect.getMinX() > (double)this.x0) {
            scrollPane.getHorizontalScrollBar().getModel().setValue(h + (this.x0 - (int)rect.getMinX()));
        } else if (rect.getMaxX() < (double)(this.x0 + 30)) {
            scrollPane.getHorizontalScrollBar().getModel().setValue(h + 30);
        }
        if (rect.getMinY() > (double)(this.y0 - 30)) {
            scrollPane.getVerticalScrollBar().getModel().setValue(v - 30);
        } else if (rect.getMaxY() < (double)this.y0) {
            scrollPane.getVerticalScrollBar().getModel().setValue(v + this.y0 - (int)rect.getMaxY());
        }
    }

    public Rectangle getBoundRectangle() {
        return this.boundRectangle;
    }

    public void setBoundRectangle(Rectangle boundRectangle) {
        this.boundRectangle = boundRectangle;
    }

    public String getLatex(int maxCintas) {
        String argsLeft = "";
        String argsRight = "";
        for (int i = 0; i < maxCintas; ++i) {
            argsLeft = argsLeft + "*,";
            argsRight = argsRight + (i == this.indiceCinta ? Utils.escapeBlank(this.getNombre()) + "," : "*,");
        }
        argsLeft = argsLeft.substring(0, argsLeft.length() - 1);
        argsRight = argsRight.substring(0, argsRight.length() - 1);
        String out = "";
        out = JTV.flagLatex ? "\\delta(q_{" + this.getIndexState2() + "}," + argsLeft + ")=(q_{" + (this.proxima == null ? "h" : this.idMaquina + "") + "}," + argsRight + ") \\\\\n" : "@" + this.getIndexState2() + ":" + argsLeft + "=" + (this.proxima == null ? "h" : this.idMaquina + "") + ":" + argsRight + "\n";
        return out;
    }

    public int getIndexState() {
        return (this.previa == null ? -1 : 1) * this.idMaquina;
    }

    public int getIndexState2() {
        return this.previa == null ? -this.idMaquina : this.previa.idMaquina;
    }

    static {
        oldNotation = true;
        running = false;
        FONT_TRI30 = new Font("TIMESROMAN", 2, 30);
        FONT_TRI25 = new Font("TIMESROMAN", 2, 25);
        FONT_TRI20 = new Font("TIMESROMAN", 2, 20);
        FONT_TRP19 = new Font("TIMESROMAN", 0, 19);
        FONT_TRI16 = new Font("TIMESROMAN", 2, 16);
        FONT_TRP16 = new Font("TIMESROMAN", 0, 16);
        FONT_TRI14 = new Font("TIMESROMAN", 2, 14);
        FONT_TRP13 = new Font("TIMESROMAN", 0, 13);
        FONT_TRI13 = new Font("TIMESROMAN", 2, 13);
        FONT_TRP10 = new Font("TIMESROMAN", 0, 10);
        FONT_AP13 = new Font("ARIAL", 0, 13);
        FONT_AP10 = new Font("ARIAL", 0, 10);
        FONT_AP8 = new Font("ARIAL", 0, 8);
        FONT_AP7 = new Font("ARIAL", 0, 7);
        RECT_INICIAL = FONT_TRI25.getStringBounds(SIMBOLO_INICIAL, new FontRenderContext(FONT_TRI25.getTransform(), true, true));
        dibujaRecursivo = false;
    }
}

