/*
 * Decompiled with CFR 0.152.
 */
package cl.jtv;

import cl.jtv.Cinta;
import cl.jtv.CondicionEnlace;
import cl.jtv.DiccionarioMetavalores;
import cl.jtv.Hellada;
import cl.jtv.JTV;
import cl.jtv.Maquina;
import cl.jtv.Metavalor;
import cl.jtv.NonSetException;
import cl.jtv.Parametro;
import cl.jtv.Simbolo;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Hashtable;

class Escritora
extends Maquina {
    public Escritora(int x, int y, Cinta c, Maquina prev, Maquina prox, String newNombre) {
        super(x, y, c, prev, prox);
        this.setNombre(newNombre);
    }

    Escritora(int x, int y, int c, Maquina prev, Maquina prox, String newNombre) {
        super(x, y, c, prev, prox);
        this.setIconValue(3);
        this.setNombre(newNombre);
    }

    public void accion() {
        this.proxima.accion();
    }

    public boolean accion(Cinta[] _arrayOfTapes, DiccionarioMetavalores dicMetavalores) {
        Metavalor metavalor = dicMetavalores.getMetavalor(this.nombre);
        if (metavalor == null) {
            if (CondicionEnlace.isNombreSimbolo(this.nombre)) {
                return _arrayOfTapes[this.getIndiceCinta()].escribir(Simbolo.getSimbolo(this.nombre));
            }
            return false;
        }
        try {
            Simbolo simbolo = (Simbolo)metavalor.getValor();
            if (simbolo == null) {
                return false;
            }
            return _arrayOfTapes[this.getIndiceCinta()].escribir(simbolo);
        }
        catch (NonSetException ex) {
            System.out.println("METAVALOR NO SETEADO");
            return false;
        }
    }

    public void dibujar(Graphics g) {
        if (Maquina.selectedMachine != null && this == Maquina.selectedMachine) {
            g.setColor(Color.magenta);
        } else if (JTV.searchedMachine != null && this == JTV.searchedMachine) {
            g.setColor(Color.pink);
        } else if (Maquina.playMachine != null && this == Maquina.playMachine) {
            g.setColor(Color.red);
        } else if (CondicionEnlace.isNombreParametro(this.nombre)) {
            g.setColor(Parametro.VERDE);
        } else {
            g.setColor(Color.black);
        }
        g.setFont(Maquina.FONT_TRI25);
        g.drawString(this.getNombre(), this.x0, this.y0);
        if (this.isInicial()) {
            g.drawString(">", this.x0 - (int)Maquina.RECT_INICIAL.getWidth(), this.y0);
        }
        if (Maquina.displayIndex) {
            g.setFont(Maquina.FONT_TRP13);
            g.drawString("(" + (this.getIndiceCinta() + 1) + ")", this.x0 + 10, this.y0 - 15);
        }
        super.dibujar(g);
    }

    public String getXML() {
        String xml = "";
        xml = xml + "<escritora \n";
        xml = xml + "    nombre=\"" + Hellada.symbol2XML(this.nombre) + "\"\n";
        xml = xml + "    id=\"" + this.idMaquina + "\"\n";
        xml = xml + "    id-previa=\"" + (this.previa == null ? "null" : Integer.toString(this.previa.idMaquina)) + "\"\n";
        xml = xml + "    id-proxima=\"" + (this.proxima == null ? "null" : Integer.toString(this.proxima.idMaquina)) + "\"\n";
        xml = xml + "    x=\"" + this.x0 + "\"\n";
        xml = xml + "    y=\"" + this.y0 + "\"\n";
        xml = xml + "    cinta=\"" + this.getIndiceCinta() + "\"\n";
        xml = xml + "    inicial=\"" + this.isInicial() + "\"\n";
        xml = xml + "/>\n\n";
        return xml;
    }

    public void reemplazaParametro(Hashtable parametros) throws NonSetException {
        String nombreParametro = this.getNombre();
        if (parametros.containsKey(nombreParametro)) {
            Parametro parametro = (Parametro)parametros.get(nombreParametro);
            if (parametro.isSet()) {
                try {
                    this.setNombre(parametro.getNombre());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                throw new NonSetException();
            }
        }
    }
}

