/*
 * Decompiled with CFR 0.152.
 */
package cl.jtv;

import cl.jtv.Cinta;
import cl.jtv.DiccionarioMetavalores;
import cl.jtv.Maquina;
import cl.jtv.Metavalor;
import cl.jtv.NonSetException;
import cl.jtv.ResultadoEvaluacion;
import cl.jtv.Simbolo;
import cl.jtv.Variable;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class CondicionEnlace {
    public Hashtable operandosIzquierdo = new Hashtable();
    public Hashtable operandosDerecho = new Hashtable();
    public Hashtable operandosNots = new Hashtable();
    private String operandos;
    private boolean not;
    public int x0;
    public int y0;

    public CondicionEnlace() {
        this.not = false;
    }

    public CondicionEnlace(boolean _not) {
        this.not = _not;
    }

    public void agregaOperandoNot(Boolean not, int newIndexTape) {
        Integer indexTape = new Integer(newIndexTape);
        if (this.operandosNots.containsKey(indexTape)) {
            this.operandosNots.remove(indexTape);
        }
        this.operandosNots.put(indexTape, not);
    }

    public void agregaOperandoIzquierdo(String operando, int newIndexTape) {
        Integer indexTape = new Integer(newIndexTape);
        if (this.operandosIzquierdo.containsKey(indexTape)) {
            this.operandosIzquierdo.remove(indexTape);
        }
        this.operandosIzquierdo.put(indexTape, operando);
    }

    public void eliminaOperandoIzquierdo(int newIndexTape) {
        Integer indexTape = new Integer(newIndexTape);
        this.operandosIzquierdo.remove(indexTape);
    }

    public void agregaOperandoDerecho(String operando, int newIndexTape) {
        Vector operandosCinta = null;
        Integer indexTape = new Integer(newIndexTape);
        if (!this.operandosDerecho.containsKey(indexTape)) {
            operandosCinta = new Vector();
            this.operandosDerecho.put(indexTape, operandosCinta);
        }
        if (!(operandosCinta = (Vector)this.operandosDerecho.get(indexTape)).contains(operando)) {
            operandosCinta.add(operando);
        }
    }

    public boolean contieneOperandoDerecho(String operando, int newIndexTape) {
        Integer indexTape = new Integer(newIndexTape);
        return this.operandosDerecho.containsKey(indexTape) && ((Vector)this.operandosDerecho.get(indexTape)).contains(operando);
    }

    public void eliminaOperandoDerecho(String operando, int newIndexTape) {
        Integer indexTape = new Integer(newIndexTape);
        Vector operandosCinta = (Vector)this.operandosDerecho.get(indexTape);
        if (operandosCinta != null) {
            operandosCinta.remove(operando);
            if (operandosCinta.isEmpty()) {
                this.operandosDerecho.remove(indexTape);
            }
        }
    }

    public boolean isNot(Integer indexCinta) {
        return (Boolean)this.operandosNots.get(indexCinta);
    }

    public boolean getNot() {
        return this.not;
    }

    public void setNot(boolean _not) {
        this.not = _not;
    }

    public void limpiarOperandosDerecho() {
        this.operandosDerecho.clear();
    }

    public void limpiarOperandosIzquierdo() {
        this.operandosIzquierdo.clear();
    }

    public ResultadoEvaluacion evaluar(Cinta[] arrayOfTapes, DiccionarioMetavalores dicMetavalores) throws NonSetException {
        int I;
        ResultadoEvaluacion out = new ResultadoEvaluacion(true, this);
        Enumeration en = this.operandosDerecho.keys();
        Vector<Boolean> resultadosBooleanos = new Vector<Boolean>();
        for (I = 0; I < this.operandosDerecho.size(); ++I) {
            resultadosBooleanos.add(Boolean.FALSE);
        }
        I = 0;
        while (en.hasMoreElements()) {
            Integer indexCinta = (Integer)en.nextElement();
            int indexCintaInt = indexCinta;
            Simbolo valorCinta = arrayOfTapes[indexCintaInt].leer();
            Vector operandosCinta = (Vector)this.operandosDerecho.get(indexCinta);
            int counterNots = 0;
            for (int i = 0; i < operandosCinta.size(); ++i) {
                String operandoCinta = (String)operandosCinta.get(i);
                if (!CondicionEnlace.isNombreSimbolo(operandoCinta) && dicMetavalores.hasMetavalor(operandoCinta)) {
                    Metavalor metavalor = dicMetavalores.getMetavalor(operandoCinta);
                    if (metavalor.getValor() == valorCinta) {
                        out.metavaloresResultado.put(indexCinta, metavalor);
                        resultadosBooleanos.set(I, this.isNot(indexCinta) ? Boolean.FALSE : Boolean.TRUE);
                        break;
                    }
                    out.metavaloresResultado.put(indexCinta, metavalor);
                    if (!this.isNot(indexCinta)) {
                        resultadosBooleanos.set(I, Boolean.FALSE);
                        continue;
                    }
                    ++counterNots;
                    continue;
                }
                if (!CondicionEnlace.isNombreSimbolo(operandoCinta) && !dicMetavalores.hasMetavalor(operandoCinta)) {
                    out.setError(true);
                    out.setStrError(operandoCinta + "=INDEFINIDO");
                    return out;
                }
                if (operandoCinta.equals(valorCinta.getNombre())) {
                    out.metavaloresResultado.put(indexCinta, Simbolo.getSimbolo(operandoCinta));
                    resultadosBooleanos.set(I, this.isNot(indexCinta) ? Boolean.FALSE : Boolean.TRUE);
                    break;
                }
                if (operandoCinta.equals(valorCinta.getNombre())) continue;
                out.metavaloresResultado.put(indexCinta, valorCinta);
                if (!this.isNot(indexCinta)) {
                    resultadosBooleanos.set(I, Boolean.FALSE);
                    continue;
                }
                ++counterNots;
            }
            if (this.isNot(indexCinta) && counterNots == operandosCinta.size()) {
                resultadosBooleanos.set(I, Boolean.TRUE);
            }
            ++I;
        }
        for (int i = 0; i < resultadosBooleanos.size(); ++i) {
            if (((Boolean)resultadosBooleanos.get(i)).booleanValue()) continue;
            out.setResultado(false);
            break;
        }
        return out;
    }

    public String asignar(Metavalor metavalor, Integer indexCinta, DiccionarioMetavalores dicMetavalores) throws NonSetException {
        String out = "";
        if (this.operandosIzquierdo.containsKey(indexCinta)) {
            String nombreVariable = (String)this.operandosIzquierdo.get(indexCinta);
            Metavalor variable = dicMetavalores.getMetavalor(nombreVariable);
            if (variable == null) {
                variable = new Variable(nombreVariable);
                dicMetavalores.insertaVariable((Variable)variable);
            }
            variable.setValor(metavalor);
            out = "[" + variable.getAsignacion() + ";" + (indexCinta + 1) + "]";
        } else {
            out = "[" + metavalor.getAsignacion() + ";" + (indexCinta + 1) + "]";
        }
        return out;
    }

    public void dibujar(Graphics g) {
        g.setFont(Maquina.FONT_TRI14);
        Set en = null;
        Enumeration en2 = null;
        if (this.operandosDerecho.size() > this.operandosIzquierdo.size()) {
            en = this.operandosDerecho.keySet();
            en2 = this.operandosIzquierdo.keys();
        } else {
            en = this.operandosIzquierdo.keySet();
            en2 = this.operandosDerecho.keys();
        }
        ArrayList list = new ArrayList(en);
        while (en2.hasMoreElements()) {
            Object obj = en2.nextElement();
            if (list.contains(obj)) continue;
            list.add(obj);
        }
        if (list.size() == 0) {
            return;
        }
        Collections.sort(list);
        for (Integer indexCinta : list) {
            String operandosCinta = "";
            if (this.operandosDerecho.containsKey(indexCinta)) {
                operandosCinta = ((Vector)this.operandosDerecho.get(indexCinta)).toString();
            }
            if (operandosCinta.length() != 0) {
                operandosCinta = operandosCinta.substring(1, operandosCinta.length() - 1);
            }
            if (this.operandosIzquierdo.containsKey(indexCinta)) {
                operandosCinta = (String)this.operandosIzquierdo.get(indexCinta) + " = " + operandosCinta;
            }
            operandosCinta = "[" + operandosCinta;
            operandosCinta = operandosCinta + (Maquina.displayIndex ? ";" + (indexCinta + 1) : "") + "]";
            Rectangle2D rect = Maquina.FONT_TRI14.getStringBounds(operandosCinta, new FontRenderContext(Maquina.FONT_TRI14.getTransform(), true, true));
            g.drawString(operandosCinta, this.x0, this.y0);
            if (this.isNot(indexCinta)) {
                g.drawLine(this.x0, this.y0 - (int)rect.getHeight() + 4, this.x0 + (int)rect.getWidth(), this.y0 - (int)rect.getHeight() + 4);
            }
            this.x0 += (int)rect.getWidth() + 1;
        }
    }

    public static boolean isNombreSimbolo(String nombreSimbolo) {
        if (nombreSimbolo == null) {
            return false;
        }
        if (nombreSimbolo.length() != 1) {
            return false;
        }
        char c = nombreSimbolo.charAt(0);
        return 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '#';
    }

    public static boolean isNombreVariable(String nombreVariable) {
        return !CondicionEnlace.isNombreParametro(nombreVariable) && !CondicionEnlace.isNombreSimbolo(nombreVariable);
    }

    public static boolean isNombreParametro(String nombreParametro) {
        if (nombreParametro.length() != 1) {
            return false;
        }
        char c = nombreParametro.charAt(0);
        return 'A' <= c && c <= 'Z';
    }

    public void setOperandos() {
        this.operandos = "";
        Enumeration en = null;
        en = this.operandosDerecho.size() > this.operandosIzquierdo.size() ? this.operandosDerecho.keys() : this.operandosIzquierdo.keys();
        while (en.hasMoreElements()) {
            Integer indexCinta = (Integer)en.nextElement();
            String operandosCinta = "";
            if (this.operandosDerecho.containsKey(indexCinta)) {
                operandosCinta = ((Vector)this.operandosDerecho.get(indexCinta)).toString();
            }
            if (operandosCinta.length() != 0) {
                operandosCinta = operandosCinta.substring(1, operandosCinta.length() - 1);
            }
            if (this.operandosIzquierdo.containsKey(indexCinta)) {
                operandosCinta = (String)this.operandosIzquierdo.get(indexCinta) + " = " + operandosCinta;
            }
            operandosCinta = "[" + operandosCinta;
            operandosCinta = operandosCinta + (Maquina.displayIndex ? ";" + (indexCinta + 1) : "") + "]";
            this.operandos = this.operandos + operandosCinta;
        }
    }

    public String getOperandos() {
        return this.operandos;
    }

    public Object clone() {
        CondicionEnlace ce = new CondicionEnlace();
        ce.operandosDerecho = (Hashtable)this.operandosDerecho.clone();
        ce.operandosIzquierdo = (Hashtable)this.operandosIzquierdo.clone();
        ce.operandosNots = (Hashtable)this.operandosNots.clone();
        ce.setOperandos();
        return ce;
    }

    public Rectangle2D getStringBounds() {
        return Maquina.FONT_TRI14.getStringBounds(this.operandos, new FontRenderContext(Maquina.FONT_TRP13.getTransform(), true, true));
    }
}

