/*
 * Decompiled with CFR 0.152.
 */
package cl.jtv;

import cl.jtv.Comando;
import cl.jtv.ComandoADD;
import cl.jtv.ComandoCOPY;
import cl.jtv.ComandoCP;
import cl.jtv.ComandoCPI;
import cl.jtv.ComandoCUT;
import cl.jtv.ComandoEM;
import cl.jtv.ComandoIE;
import cl.jtv.ComandoMM;
import cl.jtv.ComandoMM2;
import cl.jtv.ComandoRMV;
import cl.jtv.ComandoSPR;
import cl.jtv.ComandoSPRInv;
import cl.jtv.ComandoSPRInv2;
import cl.jtv.ComandoSPX;
import cl.jtv.ComandoSPXInv;
import cl.jtv.ComandoSPXInv2;
import cl.jtv.Enlace;
import cl.jtv.EnlaceCompuesto;
import cl.jtv.JTV;
import cl.jtv.JTVScanner;
import cl.jtv.Maquina;
import cl.jtv.ReferencesMachine;
import cl.jtv.Submaquina;
import cl.jtv.Vector2;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class Clipboard {
    public static int x0;
    public static int y0;
    public static int x1;
    public static int y1;
    private static Rectangle rectClipboard;
    private static DaemonClipboard daemonClipboard;
    private static Thread threadClipboard;
    private static Vector2 clipboardVector;
    private static Hashtable clipboardHashtable;
    private static boolean enabled;
    private static boolean changeInicial;
    private static boolean message;
    private static Integer monitor;
    private static int state;
    public static Maquina clipboardMachine;
    public static final int STATE_NOTHING = 0;
    public static final int STATE_CUT = 1;
    public static final int STATE_COPY = 2;
    public static final int STATE_PASTE = 3;
    public static final int STATE_DELETE = 4;
    public static final int VALID_SIZE_CLIPBOARD = 4;

    public static void drawClipboard(Graphics g) {
        if (!enabled) {
            return;
        }
        g.setColor(Color.magenta);
        g.drawRect(Math.min(x0, x1), Math.min(y0, y1), Math.abs(x1 - x0), Math.abs(y1 - y0));
        g.setColor(Color.black);
    }

    public static boolean isValidClipboard() {
        return Math.abs(x1 - x0) >= 4 || Math.abs(y1 - y0) >= 4;
    }

    private static void fillClipboard(Vector vector2) {
        Maquina maquina;
        rectClipboard.setBounds(Math.min(x0, x1), Math.min(y0, y1), Math.abs(x1 - x0), Math.abs(y1 - y0));
        Enumeration en = vector2.elements();
        clipboardHashtable.clear();
        while (en.hasMoreElements()) {
            maquina = (Maquina)en.nextElement();
            if (maquina instanceof Enlace || !rectClipboard.intersects(maquina.getBoundRectangle())) continue;
            clipboardVector.add(maquina);
            clipboardHashtable.put(new Integer(maquina.idMaquina), maquina);
        }
        en = null;
        en = vector2.elements();
        while (en.hasMoreElements()) {
            maquina = (Maquina)en.nextElement();
            if (!(maquina instanceof Enlace) || !rectClipboard.intersects(maquina.previa.getBoundRectangle()) || !rectClipboard.intersects(maquina.proxima.getBoundRectangle())) continue;
            clipboardVector.add(maquina);
        }
        if (!changeInicial && clipboardVector.size() != 0) {
            Clipboard.clipboardVector.inicial.setInicial(Clipboard.clipboardVector.inicial == ((Vector2)vector2).inicial);
            Clipboard.clipboardVector.inicial = null;
        }
    }

    public static void sendMessage(boolean message) {
        daemonClipboard.sendMessage(message);
    }

    public static void setEnabledCutCopy(boolean enabled) {
        Clipboard.daemonClipboard.jButtonCut.setEnabled(enabled);
        Clipboard.daemonClipboard.jButtonCopy.setEnabled(enabled);
        Clipboard.daemonClipboard.jMenuItemCut.setEnabled(enabled);
        Clipboard.daemonClipboard.jMenuItemCopy.setEnabled(enabled);
    }

    public static void reset() {
        state = 0;
        Clipboard.sendMessage(false);
        Clipboard.setEnabled(false);
        clipboardVector.clear();
        clipboardHashtable.clear();
    }

    public static void cut(Vector vector2) {
        Maquina maquina;
        if (state == 2) {
            return;
        }
        state = 1;
        enabled = false;
        clipboardVector.clear();
        Clipboard.fillClipboard(vector2);
        changeInicial = false;
        ComandoCUT comandoCUT = new ComandoCUT(null, null);
        ComandoCUT comandoCUTInverse = new ComandoCUT(null, null);
        comandoCUT.setInverse(comandoCUTInverse);
        Comando.addComando2UR(comandoCUT);
        Enumeration en = clipboardVector.elements();
        while (en.hasMoreElements()) {
            maquina = (Maquina)en.nextElement();
            if (!(maquina instanceof Enlace) && maquina.previa != null && !rectClipboard.intersects(maquina.previa.getBoundRectangle())) {
                ComandoSPRInv comandoSPRInv = new ComandoSPRInv(maquina, null);
                comandoCUTInverse.addComando(comandoSPRInv);
                ComandoSPR comandoSPR = new ComandoSPR(maquina, null);
                comandoCUT.addComando(comandoSPR);
                maquina.previa.proxima = null;
                maquina.previa = null;
            }
            if (!(maquina instanceof Enlace || maquina.proxima instanceof EnlaceCompuesto || maquina.proxima == null || rectClipboard.intersects(maquina.proxima.getBoundRectangle()))) {
                ComandoSPXInv comandoSPXInv = new ComandoSPXInv(maquina, null);
                comandoCUTInverse.addComando(comandoSPXInv);
                ComandoSPX comandoSPX = new ComandoSPX(maquina, null);
                comandoCUT.addComando(comandoSPX);
                maquina.proxima.previa = null;
                maquina.proxima = null;
            }
            ComandoRMV comandoRMV = new ComandoRMV(maquina, (Vector2)vector2);
            comandoCUT.addComando(comandoRMV);
            ComandoADD comandoADD = new ComandoADD(maquina, (Vector2)vector2);
            comandoCUTInverse.addComando(comandoADD);
            vector2.remove(maquina);
            if (!maquina.isInicial()) continue;
            ((Vector2)vector2).inicial = null;
            maquina.setInicial(false);
        }
        en = null;
        en = ((Vector)vector2.clone()).elements();
        while (en.hasMoreElements()) {
            ComandoIE comandoIE;
            ComandoEM comandoEM;
            maquina = (Maquina)en.nextElement();
            if (!(maquina instanceof Enlace)) continue;
            Integer idPrevia = new Integer(maquina.previa.idMaquina);
            Integer idProxima = new Integer(maquina.proxima.idMaquina);
            if (clipboardHashtable.containsKey(idPrevia) && !clipboardHashtable.containsKey(idProxima)) {
                comandoEM = new ComandoEM(maquina, (Vector2)vector2);
                comandoCUT.addComando(comandoEM);
                comandoIE = new ComandoIE(maquina, (Vector2)vector2);
                comandoCUTInverse.addComando(comandoIE);
                maquina.deleteMachine(vector2);
                continue;
            }
            if (!clipboardHashtable.containsKey(idProxima) || clipboardHashtable.containsKey(idPrevia)) continue;
            comandoEM = new ComandoEM(maquina, (Vector2)vector2);
            comandoCUT.addComando(comandoEM);
            comandoIE = new ComandoIE(maquina, (Vector2)vector2);
            comandoCUTInverse.addComando(comandoIE);
            maquina.deleteMachine(vector2);
        }
    }

    public static void copy(Vector vector2) {
        if (state == 1) {
            return;
        }
        state = 2;
        clipboardVector.clear();
        Clipboard.fillClipboard(vector2);
        changeInicial = false;
    }

    public static void paste(Vector vector2, Hashtable dicOfMachines, int x0, int y0) {
        if (clipboardMachine != null) {
            clipboardVector.clear();
            clipboardVector.add2(clipboardMachine);
        }
        switch (state) {
            case 2: {
                try {
                    Maquina maquina;
                    String xml = "";
                    xml = xml + "<jtv>\n";
                    xml = xml + clipboardVector.getXML();
                    xml = xml + "</jtv>\n";
                    String headerXML = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n\n";
                    headerXML = headerXML + "<!DOCTYPE jtv SYSTEM \"" + JTV.pathJTV + "JTV.dtd\">\n\n";
                    xml = headerXML + xml;
                    DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = builderFactory.newDocumentBuilder();
                    Document document = builder.parse(new InputSource(new StringReader(xml)));
                    ReferencesMachine.flagClipboard = true;
                    JTVScanner scanner = new JTVScanner(document);
                    scanner.visitDocument();
                    ReferencesMachine.flagClipboard = false;
                    Vector2 vector2Out = scanner.getPrincipal();
                    if (!changeInicial) {
                        vector2Out.inicial.setInicial(false);
                        vector2Out.inicial = null;
                    }
                    ComandoCOPY comando = new ComandoCOPY(null, null);
                    ComandoCOPY comandoInverse = new ComandoCOPY(null, null);
                    comando.setInverse(comandoInverse);
                    Comando.addComando2UR(comando);
                    Enumeration en = vector2Out.elements();
                    int xMin = Integer.MAX_VALUE;
                    int yMin = Integer.MAX_VALUE;
                    while (en.hasMoreElements()) {
                        maquina = (Maquina)en.nextElement();
                        if (maquina instanceof Enlace && maquina.proxima == null) continue;
                        if (maquina instanceof Submaquina) {
                            ((Submaquina)maquina).machineComponents = (Vector2)dicOfMachines.get(((Submaquina)maquina).getNombreLargo());
                        }
                        comando.addComando(new ComandoCP(maquina, (Vector2)vector2));
                        comandoInverse.addComando(new ComandoCPI(maquina, (Vector2)vector2));
                        if (!(maquina instanceof Enlace)) {
                            xMin = Math.min(xMin, maquina.x0);
                            yMin = Math.min(yMin, maquina.y0);
                        }
                        vector2.add(maquina);
                    }
                    en = null;
                    en = vector2Out.elements();
                    while (en.hasMoreElements()) {
                        maquina = (Maquina)en.nextElement();
                        if (!(maquina instanceof Enlace)) {
                            maquina.x0 += x0 - xMin;
                            maquina.y0 += y0 - yMin;
                        } else {
                            maquina.mover(x0 - xMin, y0 - yMin);
                        }
                        maquina.updateBounds();
                    }
                    break;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    break;
                }
            }
            case 1: {
                Maquina maquina;
                ComandoCUT comandoCUT = new ComandoCUT(null, null);
                ComandoCUT comandoCUTInverse = new ComandoCUT(null, null);
                comandoCUT.setInverse(comandoCUTInverse);
                Comando.addComando2UR(comandoCUT);
                int xMin = Integer.MAX_VALUE;
                int yMin = Integer.MAX_VALUE;
                Enumeration en = clipboardVector.elements();
                while (en.hasMoreElements()) {
                    maquina = (Maquina)en.nextElement();
                    if (!(maquina instanceof Enlace)) {
                        xMin = Math.min(xMin, maquina.x0);
                        yMin = Math.min(yMin, maquina.y0);
                    }
                    ComandoADD comandoADD = new ComandoADD(maquina, (Vector2)vector2);
                    comandoCUT.addComando(comandoADD);
                    ComandoRMV comandoRMV = new ComandoRMV(maquina, (Vector2)vector2);
                    comandoCUTInverse.addComando(comandoRMV);
                    vector2.add(maquina);
                }
                en = null;
                en = clipboardVector.elements();
                while (en.hasMoreElements()) {
                    maquina = (Maquina)en.nextElement();
                    if (!(maquina instanceof Enlace)) {
                        ComandoMM2 comandoMM2Inverse = new ComandoMM2(maquina, null);
                        maquina.x0 += x0 - xMin;
                        maquina.y0 += y0 - yMin;
                        ComandoMM2 comandoMM2 = new ComandoMM2(maquina, null);
                        comandoCUT.addComando(comandoMM2);
                        comandoCUTInverse.addComando(comandoMM2Inverse);
                        if (clipboardMachine != null) {
                            comandoCUTInverse.addComando(new ComandoSPRInv2(clipboardMachine, null));
                            comandoCUTInverse.addComando(new ComandoSPXInv2(clipboardMachine, null));
                            Clipboard.clipboardMachine.proxima = null;
                            Clipboard.clipboardMachine.previa = null;
                            comandoCUT.addComando(new ComandoSPRInv2(clipboardMachine, null));
                            comandoCUT.addComando(new ComandoSPXInv2(clipboardMachine, null));
                        }
                    } else {
                        ComandoMM comandoMM = new ComandoMM(maquina, null, x0 - xMin, y0 - yMin);
                        comandoCUT.addComando(comandoMM);
                        ComandoMM comandoMMInverse = new ComandoMM(maquina, null, -x0 + xMin, -y0 + yMin);
                        comandoCUTInverse.addComando(comandoMMInverse);
                        maquina.mover(x0 - xMin, y0 - yMin);
                    }
                    maquina.updateBounds();
                }
                break;
            }
        }
        enabled = false;
        if (state == 1 || state == 4) {
            state = 0;
        }
        clipboardMachine = null;
        Clipboard.sendMessage(false);
    }

    public static void delete(Vector vector2) {
        enabled = false;
        Clipboard.sendMessage(false);
        Clipboard.cut(vector2);
        state = 4;
    }

    public static void startDaemonClipboard(JButton jButtonCut, JButton jButtonCopy, JButton jButtonDelete, JMenuItem jMenuItemCut, JMenuItem jMenuItemCopy, JMenuItem jMenuItemDelete) {
        daemonClipboard = new DaemonClipboard(jButtonCut, jButtonCopy, jButtonDelete, jMenuItemCut, jMenuItemCopy, jMenuItemDelete);
        threadClipboard = new Thread(daemonClipboard);
        threadClipboard.setDaemon(true);
        threadClipboard.start();
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        Clipboard.enabled = enabled;
    }

    public static int getState() {
        return state;
    }

    public static void setState(int state) {
        Clipboard.state = state;
    }

    static {
        clipboardVector = new Vector2();
        clipboardVector.setNombreLargo("CLIPBOARD");
        clipboardVector.setPrincipal(true);
        clipboardVector.setMonocinta(false);
        rectClipboard = new Rectangle();
        clipboardHashtable = new Hashtable();
        clipboardMachine = null;
        enabled = false;
        message = false;
        state = 0;
        monitor = new Integer(0);
    }

    public static class DaemonClipboard
    implements Runnable {
        public JButton jButtonCut;
        public JButton jButtonCopy;
        public JButton jButtonDelete;
        public JMenuItem jMenuItemCut;
        public JMenuItem jMenuItemCopy;
        public JMenuItem jMenuItemDelete;

        public DaemonClipboard(JButton jButtonCut, JButton jButtonCopy, JButton jButtonDelete, JMenuItem jMenuItemCut, JMenuItem jMenuItemCopy, JMenuItem jMenuItemDelete) {
            this.jButtonCut = jButtonCut;
            this.jButtonCopy = jButtonCopy;
            this.jButtonDelete = jButtonDelete;
            this.jMenuItemCut = jMenuItemCut;
            this.jMenuItemCopy = jMenuItemCopy;
            this.jMenuItemDelete = jMenuItemDelete;
        }

        public void sendMessage(boolean message) {
            this.jButtonCut.setEnabled(message);
            this.jButtonCopy.setEnabled(message);
            this.jButtonDelete.setEnabled(message);
            this.jMenuItemCut.setEnabled(message);
            this.jMenuItemCopy.setEnabled(message);
            this.jMenuItemDelete.setEnabled(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Integer n = monitor;
                synchronized (n) {
                    this.jButtonCut.setEnabled(message);
                    this.jButtonCopy.setEnabled(message);
                    this.jButtonDelete.setEnabled(message);
                    this.jMenuItemCut.setEnabled(message);
                    this.jMenuItemCopy.setEnabled(message);
                    this.jMenuItemDelete.setEnabled(message);
                    try {
                        monitor.wait();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }
}

