/*
 * Decompiled with CFR 0.152.
 */
package cl.jtv;

import cl.jtv.CondicionEnlace;
import cl.jtv.Enlace;
import cl.jtv.JTV;
import cl.jtv.Simbolo;
import cl.jtv.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Operandos {
    private Hashtable operandos = new Hashtable();
    private Hashtable operandosComplemento = new Hashtable();
    private Enlace enlace;
    private CondicionEnlace condicionEnlace;

    public Operandos(Enlace newEnlace) {
        this.enlace = newEnlace;
        this.condicionEnlace = this.enlace.condicionEnlace;
        this.fillOperandos();
    }

    private void fillOperandos() {
        ArrayList list = new ArrayList();
        Enumeration enIzq = this.condicionEnlace.operandosNots.keys();
        while (enIzq.hasMoreElements()) {
            list.add(enIzq.nextElement());
        }
        Enumeration enDer = this.condicionEnlace.operandosDerecho.keys();
        while (enDer.hasMoreElements()) {
            Object obj = enDer.nextElement();
            if (list.contains(obj)) continue;
            list.add(obj);
        }
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            char c;
            String simbolo;
            String simbolo2;
            Vector opDer;
            Integer indexCinta = (Integer)list.get(i);
            if (this.condicionEnlace.operandosNots.get(indexCinta) == Boolean.FALSE) {
                char c2;
                this.operandos.put(indexCinta, this.condicionEnlace.operandosDerecho.get(indexCinta));
                opDer = (Vector)this.condicionEnlace.operandosDerecho.get(indexCinta);
                Vector<String> opDerRealesComp = new Vector<String>();
                for (c2 = 'a'; c2 <= 'z'; c2 = (char)(c2 + '\u0001')) {
                    simbolo2 = Simbolo.getSimbolo(c2).toString();
                    if (opDer.contains(simbolo2)) continue;
                    opDerRealesComp.add(simbolo2);
                }
                for (c2 = '0'; c2 <= '9'; c2 = (char)(c2 + '\u0001')) {
                    simbolo2 = Simbolo.getSimbolo(c2).toString();
                    if (opDer.contains(simbolo2)) continue;
                    opDerRealesComp.add(simbolo2);
                }
                simbolo = "#";
                if (!opDer.contains(simbolo)) {
                    opDerRealesComp.add(simbolo);
                }
                this.operandosComplemento.put(indexCinta, opDerRealesComp);
                continue;
            }
            opDer = (Vector)this.condicionEnlace.operandosDerecho.get(indexCinta);
            Vector<String> opDerReales = new Vector<String>();
            for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                simbolo2 = Simbolo.getSimbolo(c).toString();
                if (opDer.contains(simbolo2)) continue;
                opDerReales.add(simbolo2);
            }
            for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
                simbolo2 = Simbolo.getSimbolo(c).toString();
                if (opDer.contains(simbolo2)) continue;
                opDerReales.add(simbolo2);
            }
            simbolo = "#";
            if (!opDer.contains(simbolo)) {
                opDerReales.add(simbolo);
            }
            this.operandos.put(indexCinta, opDerReales);
            this.operandosComplemento.put(indexCinta, opDer);
        }
    }

    public Hashtable getComplemento() {
        return this.operandosComplemento;
    }

    public String getLatex(int maxCintas) {
        int N = 1;
        int maxSize = 0;
        Integer maxIndexSize = null;
        if (this.operandos.size() == 0) {
            String args = "";
            for (int j = 0; j < maxCintas; ++j) {
                args = args + "*,";
            }
            args = args.substring(0, args.length() - 1);
            String latex = "";
            latex = JTV.flagLatex ? "\\delta(q_{" + this.enlace.previa.idMaquina + "}," + args + ")=(q_{" + this.enlace.proxima.getIndexState() + "}," + args + ") \\\\\n" : "@" + this.enlace.previa.idMaquina + ":" + args + "=" + this.enlace.proxima.getIndexState() + ":" + args + "\n";
            return latex;
        }
        Enumeration en = this.operandos.keys();
        while (en.hasMoreElements()) {
            Integer indexCinta = (Integer)en.nextElement();
            int size = ((Vector)this.operandos.get(indexCinta)).size();
            if (size > maxSize) {
                maxIndexSize = indexCinta;
                maxSize = size;
            }
            N *= size;
        }
        int groupSize = N / maxSize;
        String latex = "";
        for (int i = 0; i < N; ++i) {
            String args = "";
            for (int j = 0; j < maxCintas; ++j) {
                Integer I = new Integer(j);
                Vector simbolos = (Vector)this.operandos.get(I);
                args = simbolos == null ? args + "*," : (I.intValue() == maxIndexSize.intValue() ? args + Utils.escapeBlank((String)simbolos.get(i / groupSize)) + "," : args + Utils.escapeBlank((String)simbolos.get(i % simbolos.size())) + ",");
            }
            args = args.substring(0, args.length() - 1);
            latex = JTV.flagLatex ? latex + "\\delta(q_{" + this.enlace.previa.idMaquina + "}," + args + ")=(q_{" + this.enlace.proxima.getIndexState() + "}," + args + ") \\\\\n" : latex + "@" + this.enlace.previa.idMaquina + ":" + args + "=" + this.enlace.proxima.getIndexState() + ":" + args + "\n";
        }
        return latex;
    }

    public void print() {
        Integer indexCinta;
        System.out.println("-----------------OPERANDOS------------------");
        Enumeration en = this.operandos.keys();
        while (en.hasMoreElements()) {
            indexCinta = (Integer)en.nextElement();
            System.out.println(indexCinta.toString() + ":" + ((Vector)this.operandos.get(indexCinta)).toString());
        }
        System.out.println("---------------------------------------------");
        System.out.println("-----------------COMPLEMENTO-----------------");
        en = null;
        en = this.operandosComplemento.keys();
        while (en.hasMoreElements()) {
            indexCinta = (Integer)en.nextElement();
            System.out.println(indexCinta.toString() + ":" + ((Vector)this.operandosComplemento.get(indexCinta)).toString());
        }
        System.out.println("--------------------------------------------------------");
    }
}

