/*
 * Decompiled with CFR 0.152.
 */
package cl.jtv;

import cl.jtv.AutoEnlace;
import cl.jtv.Cinta;
import cl.jtv.Enlace;
import cl.jtv.JTV;
import cl.jtv.Maquina;
import cl.jtv.Operandos;
import cl.jtv.Utils;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class EnlaceCompuesto
extends Maquina {
    public static int STATE_HALT = -1;
    private Vector enlaces;
    private int nextState = STATE_HALT;

    EnlaceCompuesto(Maquina prev) {
        super(0, 0, null, prev, null);
        this.enlaces = new Vector(10, 1);
    }

    public void accion() {
    }

    public void dibujar(Graphics g) {
        if (this.enlaces.isEmpty()) {
            return;
        }
        Enumeration en = this.enlaces.elements();
        while (en.hasMoreElements()) {
            ((Enlace)en.nextElement()).dibujar(g);
        }
    }

    public void mover(int dx, int dy) {
        System.out.println("Muevo Enlace Compuesto");
        Object[] arrayEnlaces = this.enlaces.toArray();
        for (int i = 0; i < arrayEnlaces.length; ++i) {
            ((Enlace)arrayEnlaces[i]).mover(dx, dy);
        }
    }

    public void moveRewind() {
    }

    public void moveForward() {
    }

    public void moverPrevia(int dx, int dy) {
    }

    public void moverProxima(int dx, int dy) {
        Object[] arrayEnlaces = this.enlaces.toArray();
        for (int i = 0; i < arrayEnlaces.length; ++i) {
            ((Enlace)arrayEnlaces[i]).mover(dx, dy);
        }
    }

    public void insertar(Enlace enl) {
        this.enlaces.add(enl);
    }

    public void eliminar(Enlace enl) {
        this.enlaces.remove(enl);
    }

    public Enumeration getEnlaces() {
        return this.enlaces.elements();
    }

    public int getSize() {
        return this.enlaces.size();
    }

    public int getEnlacesPosibles(Cinta[] _arrayOfTapes) {
        int out = 0;
        Enumeration en = this.getEnlaces();
        while (en.hasMoreElements()) {
            Enlace enlace = (Enlace)en.nextElement();
        }
        return out;
    }

    public boolean hasAutoenlace() {
        Enumeration en = this.getEnlaces();
        while (en.hasMoreElements()) {
            if (!(en.nextElement() instanceof AutoEnlace)) continue;
            return true;
        }
        return false;
    }

    public String getXML() {
        String xml = "";
        xml = xml + "<enlace-compuesto \n";
        xml = xml + "    id=\"" + this.idMaquina + "\"\n";
        xml = xml + "    id-previa=\"" + (this.previa == null ? "null" : Integer.toString(this.previa.idMaquina)) + "\"\n";
        xml = xml + ">\n";
        Enumeration en = this.getEnlaces();
        while (en.hasMoreElements()) {
            Enlace enlace = (Enlace)en.nextElement();
            xml = xml + enlace.getXML();
        }
        xml = xml + "</enlace-compuesto>\n";
        return xml;
    }

    public String getLatex(int maxCintas) {
        String latex = "";
        Vector<Operandos> vectorOperandos = new Vector<Operandos>();
        Enumeration en = this.getEnlaces();
        while (en.hasMoreElements()) {
            Enlace enlace = (Enlace)en.nextElement();
            Operandos operandos = new Operandos(enlace);
            latex = latex + operandos.getLatex(maxCintas);
            vectorOperandos.add(operandos);
        }
        Hashtable operandosComplementoInterseccion = this.getComplementoInterseccion(maxCintas, vectorOperandos);
        latex = latex + this.getLatexComplemento(maxCintas, operandosComplementoInterseccion);
        return latex;
    }

    private Hashtable getComplementoInterseccion(int maxCintas, Vector vectorOperandos) {
        Hashtable<Integer, Object> operandosComplementoInterseccion = new Hashtable<Integer, Object>();
        for (int i = 0; i < maxCintas; ++i) {
            Integer indexCinta = new Integer(i);
            Enumeration en = vectorOperandos.elements();
            Vector<Vector> vectorOperandosComplementoCinta = new Vector<Vector>();
            while (en.hasMoreElements()) {
                Hashtable operandosComplemento = ((Operandos)en.nextElement()).getComplemento();
                if (!operandosComplemento.containsKey(indexCinta)) continue;
                Vector vectorOperandosComplementoEnlace = (Vector)operandosComplemento.get(indexCinta);
                vectorOperandosComplementoCinta.add(vectorOperandosComplementoEnlace);
            }
            if (vectorOperandosComplementoCinta.size() == 0) continue;
            if (vectorOperandosComplementoCinta.size() == 1) {
                operandosComplementoInterseccion.put(indexCinta, vectorOperandosComplementoCinta.get(0));
                continue;
            }
            Vector<String> vectorInterseccion = new Vector<String>();
            Vector operandosComplementoInicial = (Vector)vectorOperandosComplementoCinta.get(0);
            for (int j = 1; j < vectorOperandosComplementoCinta.size(); ++j) {
                Enumeration en2 = ((Vector)vectorOperandosComplementoCinta.get(j)).elements();
                while (en2.hasMoreElements()) {
                    String operando = (String)en2.nextElement();
                    if (!operandosComplementoInicial.contains(operando)) continue;
                    vectorInterseccion.add(operando);
                }
            }
            operandosComplementoInterseccion.put(indexCinta, vectorInterseccion);
        }
        return operandosComplementoInterseccion;
    }

    private String getLatexComplemento(int maxCintas, Hashtable operandosComplementoInterseccion) {
        int N = 1;
        int maxSize = 0;
        Integer maxIndexSize = null;
        if (operandosComplementoInterseccion.size() == 0) {
            return "";
        }
        Enumeration en = operandosComplementoInterseccion.keys();
        while (en.hasMoreElements()) {
            Integer indexCinta = (Integer)en.nextElement();
            int size = ((Vector)operandosComplementoInterseccion.get(indexCinta)).size();
            if (size > maxSize) {
                maxIndexSize = indexCinta;
                maxSize = size;
            }
            N *= size;
        }
        int groupSize = N / maxSize;
        String latex = "";
        for (int i = 0; i < N; ++i) {
            String args = "";
            for (int j = 0; j < maxCintas; ++j) {
                Integer I = new Integer(j);
                Vector simbolos = (Vector)operandosComplementoInterseccion.get(I);
                args = simbolos == null ? args + "*," : (I.intValue() == maxIndexSize.intValue() ? args + Utils.escapeBlank((String)simbolos.get(i / groupSize)) + "," : args + Utils.escapeBlank((String)simbolos.get(i % simbolos.size())) + ",");
            }
            args = args.substring(0, args.length() - 1);
            latex = JTV.flagLatex ? latex + "\\delta(q_{" + this.previa.idMaquina + "}," + args + ")=(q_{" + (this.nextState == STATE_HALT ? "h" : this.nextState + "") + "}," + args + ") \\\\\n" : latex + "@" + this.previa.idMaquina + ":" + args + "=" + (this.nextState == STATE_HALT ? "h" : this.nextState + "") + ":" + args + "\n";
        }
        return latex;
    }

    public int getNextState() {
        return this.nextState;
    }

    public void setNextState(int nextState) {
        this.nextState = nextState;
    }
}

