/*
 * Decompiled with CFR 0.152.
 */
package cl.jtv;

import cl.jtv.Arrow;
import cl.jtv.Cinta;
import cl.jtv.CondicionEnlace;
import cl.jtv.DialogEnlace;
import cl.jtv.DiccionarioMetavalores;
import cl.jtv.EnlaceCompuesto;
import cl.jtv.Hellada;
import cl.jtv.JTV;
import cl.jtv.Maquina;
import cl.jtv.NonSetException;
import cl.jtv.Parametro;
import cl.jtv.ResultadoEvaluacion;
import cl.jtv.Simbolo;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

class Enlace
extends Maquina {
    int x1;
    int y1;
    public CondicionEnlace condicionEnlace = new CondicionEnlace();
    private Vector puntos;
    private Vector rectas;
    private Point p0;
    private Point p1;
    protected Arrow arrow = new Arrow();
    private int w0;
    private int h0;
    private int w1;
    private int h1;
    static final Font FONT_TRI10 = new Font("TIMESROMAN", 2, 10);
    public static final int COORD_N = 0;
    public static final int COORD_S = 1;
    public static final int COORD_E = 2;
    public static final int COORD_W = 3;
    public static final int COORD_NE = 4;
    public static final int COORD_NW = 5;
    public static final int COORD_SE = 6;
    public static final int COORD_SW = 7;

    public Enlace(int x, int y) {
        super(x, y, 0, null, null);
        this.puntos = new Vector();
        this.setIconValue(2);
    }

    public Enlace(int x, int y, Cinta cin, Maquina prev, Maquina prox) {
        super(x, y, cin, prev, prox);
        this.setExtremos();
        this.setIconValue(2);
    }

    public Enlace(int x, int y, Cinta cin, Maquina prev, Maquina prox, String _nombre) {
        super(x, y, cin, prev, prox);
        this.p0 = new Point();
        this.p1 = new Point();
        this.setExtremos();
        this.setIconValue(8);
    }

    public Enlace(int x, int y, int _indiceCinta, Maquina prev, Maquina prox) {
        super(x, y, _indiceCinta, prev, prox);
        this.p0 = new Point();
        this.p1 = new Point();
        this.puntos = new Vector();
        this.setExtremos();
        this.setIconValue(8);
    }

    public void setPoints() {
        this.p0 = new Point();
        this.p1 = new Point();
        this.setExtremos();
    }

    public void setExtremos() {
        Rectangle2D rect1 = this.previa.getBounds();
        Rectangle2D rect2 = this.proxima.getBounds();
        this.w0 = (int)rect1.getWidth();
        this.h0 = (int)rect1.getHeight();
        this.w1 = (int)rect2.getWidth();
        this.h1 = (int)rect2.getHeight();
        if (this.puntos.isEmpty()) {
            Point[] puntos = Enlace.getCoord2(this.w0, this.h0, this.w1, this.h1, this.previa.x0, this.previa.y0, this.proxima.x0, this.proxima.y0);
            this.p0 = puntos[0];
            this.p1 = puntos[1];
        } else {
            Object[] arrayPuntos = this.puntos.toArray();
            Point pi = (Point)arrayPuntos[0];
            Point pf = (Point)arrayPuntos[arrayPuntos.length - 1];
            this.p0 = Enlace.getCoord(this.h0, this.w0, this.previa.x0, this.previa.y0, (int)pi.getX(), (int)pi.getY());
            this.p1 = Enlace.getCoord(this.h1, this.w1, this.proxima.x0, this.proxima.y0, (int)pf.getX(), (int)pf.getY());
        }
    }

    public void accion() {
    }

    public void accion(Cinta _cinta) {
    }

    public void mover(int dx, int dy) {
        if (!this.esCiclico()) {
            return;
        }
        this.condicionEnlace.x0 += dx;
        this.condicionEnlace.y0 += dy;
        Object[] arrayPuntos = this.puntos.toArray();
        for (int i = 0; i < arrayPuntos.length; ++i) {
            ((Point)arrayPuntos[i]).setLocation((int)((Point)arrayPuntos[i]).getX() + dx, (int)((Point)arrayPuntos[i]).getY() + dy);
        }
    }

    public void moverPrevia(int dx, int dy) {
    }

    public void moverProxima(int dx, int dy) {
    }

    public void moveRewind() {
    }

    public void moveForward() {
    }

    public void moveForward2() {
    }

    public void deleteMachine(Vector repository) {
        ((EnlaceCompuesto)this.previa.proxima).eliminar(this);
        if (((EnlaceCompuesto)this.previa.proxima).getSize() == 0) {
            this.previa.proxima = null;
        }
        repository.remove(this);
    }

    public void dibujar(Graphics g) {
        if (Maquina.selectedMachine != null && this == Maquina.selectedMachine) {
            g.setColor(Color.magenta);
        } else if (JTV.searchedMachine != null && this == JTV.searchedMachine) {
            g.setColor(Color.pink);
        } else if (Maquina.playMachine != null && this == Maquina.playMachine) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.black);
        }
        g.setFont(FONT_TRI10);
        this.setExtremos();
        if (this.puntos.isEmpty()) {
            g.drawLine((int)this.p0.getX(), (int)this.p0.getY(), (int)this.p1.getX(), (int)this.p1.getY());
            this.arrow.drawArrow(g, (int)this.p0.getX(), (int)this.p0.getY(), (int)this.p1.getX(), (int)this.p1.getY());
            int x0 = (int)this.p0.getX();
            int y0 = (int)this.p0.getY();
            int x1 = (int)this.p1.getX();
            int y1 = (int)this.p1.getY();
            this.condicionEnlace.setOperandos();
            Rectangle2D rect = FONT_TRI10.getStringBounds(this.condicionEnlace.getOperandos(), new FontRenderContext(FONT_TRI10.getTransform(), true, true));
            double sin = (double)Math.abs(y0 - y1) / Math.sqrt(Math.pow(y1 - y0, 2.0) + Math.pow(x1 - x0, 2.0));
            this.condicionEnlace.x0 = (x0 + x1) / 2 + 3 * (int)sin - (int)(rect.getWidth() * (1.0 - sin) / 2.0);
            this.condicionEnlace.y0 = (y0 + y1) / 2;
            this.condicionEnlace.dibujar(g);
        } else {
            Point auxPoint0 = this.p0;
            Enumeration en = this.puntos.elements();
            while (en.hasMoreElements()) {
                Point auxPoint1 = (Point)en.nextElement();
                if (JTV.estadoJTV == 17 && !Maquina.running) {
                    g.fillRect((int)(auxPoint1.getX() - 2.5), (int)(auxPoint1.getY() - 2.5), 5, 5);
                }
                g.drawLine((int)auxPoint0.getX(), (int)auxPoint0.getY(), (int)auxPoint1.getX(), (int)auxPoint1.getY());
                auxPoint0 = auxPoint1;
            }
            g.drawLine((int)auxPoint0.getX(), (int)auxPoint0.getY(), (int)this.p1.getX(), (int)this.p1.getY());
            this.arrow.drawArrow(g, (int)auxPoint0.getX(), (int)auxPoint0.getY(), (int)this.p1.getX(), (int)this.p1.getY());
            int x0_ = (int)auxPoint0.getX();
            int y0_ = (int)auxPoint0.getY();
            int x1_ = (int)this.p1.getX();
            int y1_ = (int)this.p1.getY();
            this.condicionEnlace.setOperandos();
            Rectangle2D rect = FONT_TRI10.getStringBounds(this.condicionEnlace.getOperandos(), new FontRenderContext(FONT_TRI10.getTransform(), true, true));
            double sin = (double)Math.abs(y0_ - y1_) / Math.sqrt(Math.pow(y1_ - y0_, 2.0) + Math.pow(x1_ - x0_, 2.0));
            this.condicionEnlace.x0 = (x0_ + x1_) / 2 + 7 * (int)sin - (int)(rect.getWidth() * (1.0 - sin) / 2.0);
            this.condicionEnlace.y0 = (y0_ + y1_) / 2;
            this.condicionEnlace.dibujar(g);
        }
        if (!this.esCiclico()) {
            super.dibujar(g);
        }
    }

    public boolean accion(Cinta[] _arrayOfTapes, DiccionarioMetavalores dicMetavalores) {
        Enumeration en = this.condicionEnlace.operandosIzquierdo.keys();
        try {
            while (en.hasMoreElements()) {
                Integer indexCinta = (Integer)en.nextElement();
                Simbolo simbolo = _arrayOfTapes[indexCinta].leer();
                this.condicionEnlace.asignar(simbolo, indexCinta, dicMetavalores);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public ResultadoEvaluacion evaluarCondicion(Cinta[] arrayOfTapes, DiccionarioMetavalores dicMetavalores) throws NonSetException {
        return this.condicionEnlace.evaluar(arrayOfTapes, dicMetavalores);
    }

    public int getMaxIndiceCinta() {
        Set en = null;
        Enumeration en2 = null;
        if (this.condicionEnlace.operandosDerecho.size() > this.condicionEnlace.operandosIzquierdo.size()) {
            en = this.condicionEnlace.operandosDerecho.keySet();
            en2 = this.condicionEnlace.operandosIzquierdo.keys();
        } else {
            en = this.condicionEnlace.operandosIzquierdo.keySet();
            en2 = this.condicionEnlace.operandosDerecho.keys();
        }
        ArrayList list = new ArrayList(en);
        while (en2.hasMoreElements()) {
            Object obj = en2.nextElement();
            if (list.contains(obj)) continue;
            list.add(obj);
        }
        if (list.size() == 0) {
            return 0;
        }
        return (Integer)list.get(list.size() - 1);
    }

    public boolean esCiclico() {
        Maquina auxMaquina = this.previa;
        while (auxMaquina != null) {
            if (auxMaquina instanceof Enlace) {
                return false;
            }
            if (auxMaquina == this.proxima) {
                return true;
            }
            auxMaquina = auxMaquina.previa;
        }
        return false;
    }

    public void agregaPunto(int x, int y) {
        this.puntos.add(new Point(x, y));
    }

    private static double L1(int h, int w, int x0, int y0, int xi) {
        return h * xi / w + y0 - h / 2 - h / w * (x0 + w / 2);
    }

    private static double L2(int h, int w, int x0, int y0, int xi) {
        return -h * xi / w + y0 - h / 2 + h / w * (x0 + w / 2);
    }

    private static Point getCoord(int h, int w, int x0, int y0, int xi, int yi) {
        double L1 = Enlace.L1(h, w, x0, y0, xi);
        double L2 = Enlace.L2(h, w, x0, y0, xi);
        if (L1 > (double)yi && L2 > (double)yi) {
            return new Point(x0 + w / 2, y0 - h + 10);
        }
        if (L1 < (double)yi && L2 < (double)yi) {
            return new Point(x0 + w / 2, y0);
        }
        if (L1 > (double)yi && L2 < (double)yi) {
            return new Point(x0 + w, y0 - h / 2);
        }
        if (L1 < (double)yi && L2 > (double)yi) {
            return new Point(x0, y0 - h / 2);
        }
        if (L1 == (double)yi && L2 > (double)yi) {
            return new Point(x0, y0 - h);
        }
        if (L2 == (double)yi && L1 > (double)yi) {
            return new Point(x0 + w, y0 - h);
        }
        if (L1 == (double)yi && L2 < (double)yi) {
            return new Point(x0, y0 + w);
        }
        if (L2 == (double)yi && L1 < (double)yi) {
            return new Point(x0, y0);
        }
        return new Point();
    }

    public static Point[] getCoord2(int w0, int h0, int w1, int h1, int x0, int y0, int x1, int y1) {
        Point[] p0 = new Point[]{new Point(x0 + w0 / 2, y0 - h0 + 10), new Point(x0 + w0 / 2, y0), new Point(x0 + w0, y0 - h0 / 2), new Point(x0, y0 - h0 / 2)};
        Point[] p1 = new Point[]{new Point(x1 + w1 / 2, y1 - h1 + 10), new Point(x1 + w1 / 2, y1), new Point(x1 + w1, y1 - h1 / 2), new Point(x1, y1 - h1 / 2)};
        Hashtable<Double, Point[]> medidas = new Hashtable<Double, Point[]>();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                Point[] puntos = new Point[]{p0[i], p1[j]};
                medidas.put(new Double(Point.distance(p0[i].getX(), p0[i].getY(), p1[j].getX(), p1[j].getY())), puntos);
            }
        }
        ArrayList list = new ArrayList(medidas.keySet());
        Collections.sort(list);
        return (Point[])medidas.get(list.get(0));
    }

    public boolean isMouseClicked(int x, int y) {
        Object[] puntos = this.puntos.toArray();
        if (puntos.length == 0 && new Line2D.Double(this.p0, this.p1).intersects(x, y, 3.0, 3.0)) {
            return true;
        }
        if (puntos.length != 0) {
            if (new Line2D.Double(this.p0, (Point)puntos[0]).intersects(x, y, 3.0, 3.0)) {
                return true;
            }
            if (new Line2D.Double((Point)puntos[puntos.length - 1], this.p1).intersects(x, y, 3.0, 3.0)) {
                return true;
            }
            for (int i = 0; i < puntos.length - 1; ++i) {
                if (!new Line2D.Double((Point)puntos[i], (Point)puntos[i + 1]).intersects(x, y, 3.0, 3.0)) continue;
                return true;
            }
        }
        return false;
    }

    public Point getNearestPoint(int x, int y) {
        if (this.puntos.size() == 0) {
            return null;
        }
        Enumeration en = this.puntos.elements();
        while (en.hasMoreElements()) {
            Point punto = (Point)en.nextElement();
            if (!(Math.sqrt(Math.pow(punto.getX() - (double)x, 2.0) + Math.pow(punto.getY() - (double)y, 2.0)) < 5.0)) continue;
            return punto;
        }
        return null;
    }

    public void updateBounds() {
    }

    public boolean esEnlazable() {
        return false;
    }

    public int showDialog(int numOfTapes, boolean addComando) {
        DialogEnlace dv = new DialogEnlace(new JFrame(), true, numOfTapes, this, addComando);
        dv.setSize(400, 400);
        dv.setVisible(true);
        return dv.getReturnStatus();
    }

    public String getXML() {
        Integer indexCinta;
        String xml = "";
        xml = xml + "<enlace \n";
        xml = xml + "    id=\"" + this.idMaquina + "\"\n";
        xml = xml + "    id-previa=\"" + this.previa.idMaquina + "\"\n";
        xml = xml + "    id-proxima=\"" + this.proxima.idMaquina + "\"\n";
        if (this.condicionEnlace.operandosDerecho.size() == 0 && this.condicionEnlace.operandosIzquierdo.size() == 0) {
            if (this.puntos.size() == 0) {
                xml = xml + "/>\n\n";
                return xml;
            }
            xml = xml + ">\n\n";
            Enumeration en = this.puntos.elements();
            while (en.hasMoreElements()) {
                Point punto = (Point)en.nextElement();
                xml = xml + "     <punto x=\"" + (int)punto.getX() + "\" y=\"" + (int)punto.getY() + "\"/>\n";
            }
            xml = xml + "</enlace>\n";
            return xml;
        }
        xml = xml + ">\n\n";
        Enumeration<Object> en = this.condicionEnlace.operandosDerecho.keys();
        while (en.hasMoreElements()) {
            indexCinta = (Integer)en.nextElement();
            Vector operandosDerecho = (Vector)this.condicionEnlace.operandosDerecho.get(indexCinta);
            xml = xml + "    <condicion cinta=\"" + indexCinta + "\" not=\"" + ((Boolean)this.condicionEnlace.operandosNots.get(indexCinta)).toString() + "\"";
            if (this.condicionEnlace.operandosIzquierdo.containsKey(indexCinta)) {
                String operandoIzquierdo = (String)this.condicionEnlace.operandosIzquierdo.get(indexCinta);
                xml = xml + " operando-izquierdo=\"" + Hellada.symbol2XML(operandoIzquierdo) + "\"";
            }
            if (operandosDerecho.size() == 0) {
                xml = xml + "/>\n";
                continue;
            }
            xml = xml + ">\n";
            Enumeration en2 = operandosDerecho.elements();
            while (en2.hasMoreElements()) {
                String operandoDerecho = (String)en2.nextElement();
                xml = xml + "          <operando-derecho nombre=\"" + Hellada.symbol2XML(operandoDerecho) + "\"/>\n";
            }
            xml = xml + "     </condicion>\n";
        }
        en = null;
        en = this.condicionEnlace.operandosIzquierdo.keys();
        while (en.hasMoreElements()) {
            indexCinta = (Integer)en.nextElement();
            if (this.condicionEnlace.operandosDerecho.containsKey(indexCinta)) continue;
            String operandoIzquierdo = (String)this.condicionEnlace.operandosIzquierdo.get(indexCinta);
            xml = xml + "     <condicion cinta=\"" + indexCinta + "\" not=\"" + ((Boolean)this.condicionEnlace.operandosNots.get(indexCinta)).toString() + "\"";
            xml = xml + " operando-izquierdo=\"" + Hellada.symbol2XML(operandoIzquierdo) + "\"/>\n";
        }
        en = null;
        en = this.puntos.elements();
        while (en.hasMoreElements()) {
            Point punto = (Point)en.nextElement();
            xml = xml + "     <punto x=\"" + (int)punto.getX() + "\" y=\"" + (int)punto.getY() + "\"/>\n";
        }
        xml = xml + "</enlace>\n";
        return xml;
    }

    public void setScrollBars(JScrollPane scrollPane) {
        this.proxima.setScrollBars(scrollPane);
    }

    public Vector getPuntos() {
        return this.puntos;
    }

    public void setPuntos(Vector puntos) {
        this.puntos = puntos;
    }

    public String getLatex(int maxCintas) {
        return "";
    }

    public void reemplazaParametro(Hashtable parametros) throws NonSetException {
        Enumeration en = this.condicionEnlace.operandosDerecho.elements();
        while (en.hasMoreElements()) {
            String operando;
            Vector operandos = (Vector)en.nextElement();
            Enumeration en2 = operandos.elements();
            if (!en2.hasMoreElements() || !parametros.containsKey(operando = (String)en2.nextElement())) continue;
            Parametro parametro = (Parametro)parametros.get(operando);
            if (parametro.isSet()) {
                operandos.remove(operando);
                try {
                    operandos.add(parametro.getNombre());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            throw new NonSetException();
        }
    }
}

