/*
 * Simbolo.java
 *
 * Created on 3 de octubre de 2002, 03:51 AM
 */

/**
 *
 * @author  Administrador
 * @version 
 */
import java.util.Hashtable;

public class Simbolo implements Metavalor {

    /** Creates new Simbolo */
    private char valor;
    private String nombre;
    private static Hashtable simbolos;
    
    public Simbolo(char newValor) {
       
        valor = newValor;
        nombre = String.valueOf(newValor);
    }
    
    static{
        
        simbolos = new Hashtable();
        
        for(char c='a';c<='z';c++)
            simbolos.put(String.valueOf(c),new Simbolo(c));
        for(char c='0';c<='9';c++)
            simbolos.put(String.valueOf(c),new Simbolo(c));
        
        simbolos.put("#",new Simbolo('#'));
    }
    
    public static Simbolo getSimbolo(char charSimbolo){
        
        return getSimbolo(String.valueOf(charSimbolo));
    }
    
    public static Simbolo getSimbolo(String nombreSimbolo){
        
        return (Simbolo)simbolos.get(nombreSimbolo);
    }
    
    public void setValor(char newValor){
        
        valor = newValor;
        nombre = String.valueOf(newValor);
    }
    
    public void setValor(Metavalor newValor){
        
        return;
    }
    
    public Metavalor getValor(){
        
        return this;
        
    }
    
    public boolean equals(Metavalor valor) throws NonSetException{
        
        return this.getValor()==valor.getValor();
    }
    
    public String getNombre() throws NonSetException{
        
        return nombre;
    }    
   
    public void decrReferencias() {
        return;
    }    

    public void incrReferencias() {
        return;
    }
    
    public boolean noReferencias() {
        return true;
    }
    
    public String getAsignacion() throws NonSetException {
        
        return getNombre();
    }
    
    public void setNombre(String newNombre) {
        return;
    }
    
}
