/*
 * DialogSimboloLimite.java
 *
 * Created on 15 de agosto de 2001, 02:49 AM
 */


/**
 *
 * @author  Marco Mora Godoy
 * @version 
 */
import javax.swing.*;
import javax.swing.JOptionPane.*;

public class DialogNotacion extends javax.swing.JDialog {
    /** A return status code - returned if Cancel button has been pressed */
    public static final int RET_CANCEL = 0;
    /** A return status code - returned if OK button has been pressed */
    public static final int RET_OK = 1;

    /** Creates new form DialogSimboloLimite */
    public DialogNotacion(java.awt.Frame parent, boolean modal) {
        super (parent, modal);
        initComponents ();
        this.setLocation(200,200);
        this.jRadioButton1.setSelected(Maquina.oldNotation);
        this.jRadioButton2.setSelected(!Maquina.oldNotation);
        //this.buttonGroup1.setSelected(this.buttonGroup1.getSelection(),true);
        pack ();
    }

    /** @return the return status of this dialog - one of RET_OK or RET_CANCEL */
    public int getReturnStatus () {
        return returnStatus;
    }
    
   

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        buttonGroup1 = new javax.swing.ButtonGroup();
        buttonPanel = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        jRadioButton1 = new javax.swing.JRadioButton();
        jRadioButton2 = new javax.swing.JRadioButton();
        
        
        setTitle("Cambio de Notaci\u00f3n");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        
        okButton.setText("OK");
        okButton.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });
        
        buttonPanel.add(okButton);
        
        cancelButton.setText("Cancelar");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        
        buttonPanel.add(cancelButton);
        
        getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);
        
        jPanel1.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        jRadioButton1.setText("Antigua");
        buttonGroup1.add(jRadioButton1);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        jPanel1.add(jRadioButton1, gridBagConstraints1);
        
        jRadioButton2.setText("Nueva");
        buttonGroup1.add(jRadioButton2);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        jPanel1.add(jRadioButton2, gridBagConstraints1);
        
        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);
        
        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(300, 200));
        setLocation((screenSize.width-300)/2,(screenSize.height-200)/2);
    }//GEN-END:initComponents

    private void okButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        
        Maquina.oldNotation = this.jRadioButton1.isSelected(); 
        doClose (RET_OK);
        
        
    }//GEN-LAST:event_okButtonActionPerformed

    private void cancelButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        doClose (RET_CANCEL);
    }//GEN-LAST:event_cancelButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        doClose (RET_CANCEL);
    }//GEN-LAST:event_closeDialog

    private void doClose (int retStatus) {
        returnStatus = retStatus;
        setVisible (false);
        dispose ();
    }
    


    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) {
        new DialogNotacion(new javax.swing.JFrame (), true).show ();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton okButton;
    private javax.swing.JButton cancelButton;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JRadioButton jRadioButton1;
    private javax.swing.JRadioButton jRadioButton2;
    // End of variables declaration//GEN-END:variables

    private int returnStatus = RET_CANCEL;
}
