/*
 * DialogSimboloLimite.java
 *
 * Created on 15 de agosto de 2001, 02:49 AM
 */


/**
 *
 * @author  Marco Mora Godoy
 * @version 
 */
import javax.swing.*;
import javax.swing.JOptionPane.*;

public class DialogMaximoRafaga extends javax.swing.JDialog {
    /** A return status code - returned if Cancel button has been pressed */
    public static final int RET_CANCEL = 0;
    /** A return status code - returned if OK button has been pressed */
    public static final int RET_OK = 1;

    /** Creates new form DialogSimboloLimite */
    public DialogMaximoRafaga(java.awt.Frame parent, boolean modal) {
        super (parent, modal);
        initComponents ();
        this.setLocation(200,200);
        this.jTextField2.setText(Integer.toString(SharedInteger.getMaxValue()));
        this.jTextField2.selectAll();
        pack ();
    }

    /** @return the return status of this dialog - one of RET_OK or RET_CANCEL */
    public int getReturnStatus () {
        return returnStatus;
    }
    
   

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        buttonPanel = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jTextField2 = new javax.swing.JTextField();
        
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        
        okButton.setText("OK");
        okButton.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });
        
        buttonPanel.add(okButton);
        
        cancelButton.setText("Cancelar");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        
        buttonPanel.add(cancelButton);
        
        getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);
        
        jPanel1.setLayout(new java.awt.GridLayout(1, 2));
        
        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel3.setText("Tama\u00f1o de R\u00e1faga");
        jPanel1.add(jLabel3);
        
        jPanel1.add(jTextField2);
        
        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);
        
    }//GEN-END:initComponents

    private void okButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        try{
            int maxRafaga = Integer.parseInt(jTextField2.getText());
            if(maxRafaga<=4){
                JOptionPane.showMessageDialog(null, "Debe ingresar un nmero entero mayor o igual que 5","JTV",JOptionPane.WARNING_MESSAGE);
                jTextField2.setText("");
                this.jTextField2.requestFocus();
            }
            else{
                SharedInteger.setMaxValue(maxRafaga);   
                doClose (RET_OK);
            }
        }
        catch(NumberFormatException ex){
            JOptionPane.showMessageDialog(null, "Debe ingresar un nmero entero mayor o igual que 5","JTV",JOptionPane.WARNING_MESSAGE);
            jTextField2.setText("");
            this.jTextField2.requestFocus();
            
        }
        
    }//GEN-LAST:event_okButtonActionPerformed

    private void cancelButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        doClose (RET_CANCEL);
    }//GEN-LAST:event_cancelButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        doClose (RET_CANCEL);
    }//GEN-LAST:event_closeDialog

    private void doClose (int retStatus) {
        returnStatus = retStatus;
        setVisible (false);
        dispose ();
    }
    


    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) {
        new DialogSimboloLimite (new javax.swing.JFrame (), true).show ();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton okButton;
    private javax.swing.JButton cancelButton;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JTextField jTextField2;
    // End of variables declaration//GEN-END:variables

    private int returnStatus = RET_CANCEL;
}
