

//Title:        Proyecto Turing Visual

//Version:

//Copyright:    Copyright (c) 1998

//Author:       Marco Antonio Mora Godoy

//Company:      Your Company

//Description:  No admires, CREA!!!!...




import java.awt.*;
import java.awt.font.FontRenderContext;
import java.lang.*;
import java.util.*;


public class Cinta{



  int x0,y0;

  private int i_cabezal,i_cabezal0;

  private Hashtable caracteres,caracteres0;

  int numero;
  

  static final int MAX_i_cabezal=1024;

  static final int VECINDAD=20;

  static final int MAXd2=512; //(int)(MAX_i_cabezal/2);

  static final int H = 17;
  
  static final int D = 2;
  
  static final Font FONT_ARI17 = new Font("ARIAL",Font.BOLD,H);
  
  static final Font FONT_ARI5 = new Font("ARIAL",Font.BOLD,10);
  
  static final Font FONT_TRP17 = new Font("TIMESROMAN",Font.PLAIN,H);

  static final Font FONT_CB = new Font("COURIER",Font.BOLD,15);

  static final int delta_x=5;

  static final int delta_y=13;
  
  static final Simbolo BLANCO = Simbolo.getSimbolo("#");

  public boolean writeMode=false;
  public boolean browseMode=false;
  private int pageBrowse=0,pageHead;
  
  public Cinta(int x,int y,int num) {



    i_cabezal= 0;

    caracteres = new Hashtable();

    x0 = x;

    y0 = y;

    numero = num;
    
    i_cabezal0 = i_cabezal;
    caracteres0 = this.getCloneCaracteres();
        
    
  }
  
  public Cinta(Cinta _cinta) {



    i_cabezal= _cinta.getIndiceCabezal();

    caracteres = _cinta.getCloneCaracteres();

    x0 = _cinta.x0;

    y0 = _cinta.y0;

    numero = _cinta.numero;
    
    i_cabezal0 = i_cabezal;
    caracteres0 = this.getCloneCaracteres();
      
       
  }
  
  public Cinta(Cinta _cinta,boolean flag) {



    i_cabezal= _cinta.getIndiceCabezal();

    caracteres = _cinta.getCloneCaracteres();

    x0 = _cinta.x0;

    y0 = _cinta.y0;

    numero = _cinta.numero;
    
    i_cabezal0 = _cinta.getIndiceCabezal0();
    try{
        caracteres0 = (Hashtable)_cinta.getCaracteres0().clone();
    }
    catch(Exception ex){
        
    }
    
    
  }
  
  
  public void setValoresIniciales(){
      
      i_cabezal = i_cabezal0;
      try{
        caracteres = (Hashtable) caracteres0.clone();
      }
      catch(Exception ex){
          
      }
  }

  public Simbolo leer(){
      
      if(!caracteres.containsKey(this.indiceCabezal2Integer()))
          return Cinta.BLANCO;
      else
          return ((Simbolo)caracteres.get(this.indiceCabezal2Integer()));
  }


  public boolean escribir(Simbolo simbolo){
   
      caracteres.remove(this.indiceCabezal2Integer());
      if(simbolo!=Cinta.BLANCO)
         caracteres.put(this.indiceCabezal2Integer(),simbolo);
      
      return true;
   
  }
  
   public void setIndiceCabezal(int _indice){
        
        this.i_cabezal = _indice;
   }
   
   public void setIndiceCabezal0(int _indice){
        
        this.i_cabezal0 = _indice;
   }

   public int getIndiceCabezal(){
    
       return this.i_cabezal;
       
   }
   
   public int getIndiceCabezal0(){
    
       return this.i_cabezal0;
       
   }
   
   public Hashtable getCaracteres0(){
       
        return this.caracteres0;
   }
   
   public Hashtable getCaracteres(){
      
        return this.caracteres;
      
  }

  public boolean mover_L(){



    if(i_cabezal == 0){
      System.out.println("MAQUINA COLGADA");
      return false;
    }
    
    i_cabezal--;
    this.pageBrowse = i_cabezal/(2*Cinta.VECINDAD+1);
    
    return true;

  }



   public boolean mover_R(){



    //if(i_cabezal == Cinta.MAX_i_cabezal)

    //  return false;

   
    i_cabezal++;
    this.pageBrowse = i_cabezal/(2*Cinta.VECINDAD+1);

    return true;

  }
  
  public void incrCabezal(){
      
        this.i_cabezal++;
        this.i_cabezal0++;
        this.pageBrowse = i_cabezal/(2*Cinta.VECINDAD+1);
  }
  
  public void decrCabezal(){
        
      if(this.i_cabezal==0) return;
      
      this.i_cabezal--;
      this.i_cabezal0--;
      this.pageBrowse = i_cabezal/(2*Cinta.VECINDAD+1);
      
      
  }
  
      
  public void limpiar(){



    i_cabezal = i_cabezal0 = pageBrowse = 0;
    caracteres.clear();
    caracteres0.clear();
  }

  public void cargar(Simbolo simbolo){
      
      caracteres.remove(this.indiceCabezal2Integer());
      caracteres0.remove(this.indiceCabezal2Integer());
      if(simbolo!=Cinta.BLANCO){
         caracteres.put(this.indiceCabezal2Integer(),simbolo);
         caracteres0.put(this.indiceCabezal2Integer(),simbolo);
      }
 
      i_cabezal++;
      i_cabezal0++;
      
      this.pageBrowse = i_cabezal/(2*Cinta.VECINDAD+1);
      
  }

  public void cargar(String input){



    //for(int i=0;i< Cinta.MAX_i_cabezal;i++)

    //  caracteres[i]='#';

    limpiar();

    

    if(input==null || input.length()==0) return;



    for(int i=0;i<input.length();i++){

      caracteres.put(new Integer(i+1),Simbolo.getSimbolo(input.charAt(i)));
      caracteres0.put(new Integer(i+1),Simbolo.getSimbolo(input.charAt(i)));
    }
    
    i_cabezal = i_cabezal0 = input.length()+1;  //AGREGADO 14-12-2002
       
  }

  public void dibujar(Graphics g) throws NonSetException{
      
    int i,j;

    //g.setFont(Cinta.FONT_TRP17);
    g.setFont(Cinta.FONT_ARI17);
    g.drawString("" + numero,x0-15-14-8-H,y0+H);

    g.setColor(Color.red);
    g.fillRect(x0-D-2*H,y0+H/4,2*H,H/2+1);
    g.fillRect(x0+D+(2*Cinta.VECINDAD+1)*H,y0+H/4,2*H,H/2+1);
    g.setFont(Cinta.FONT_ARI5);
    this.pageHead = (getIndiceCabezal()/(2*Cinta.VECINDAD+1));
    //this.pageBrowse = this.browseMode?this.pageBrowse:this.pageHead;
    //int delta = (this.browseMode?this.pageBrowse:this.pageHead)*(2*Cinta.VECINDAD+1);
    int delta = this.pageBrowse*(2*Cinta.VECINDAD+1);
    String indiceInicial = String.valueOf(delta);
    String indiceFinal = String.valueOf(delta+2*Cinta.VECINDAD);
    java.awt.geom.Rectangle2D rectIni = Cinta.FONT_ARI5.getStringBounds(indiceInicial,new FontRenderContext(Cinta.FONT_ARI5.getTransform(),true,true));
    java.awt.geom.Rectangle2D rectFin = Cinta.FONT_ARI5.getStringBounds(indiceFinal,new FontRenderContext(Cinta.FONT_ARI5.getTransform(),true,true));
    g.setColor(Color.white);
    g.drawString(indiceInicial,x0-D-H-(int)rectIni.getWidth()/2,y0+3*H/4);
    g.drawString(indiceFinal,x0+D+(2*Cinta.VECINDAD+1)*H+H-(int)rectFin.getWidth()/2,y0+3*H/4);
    g.setColor(Color.black);

    g.drawRect(x0,y0,(2*Cinta.VECINDAD+1)*Cinta.H,Cinta.H);
    //Agregado
    g.setColor(Color.cyan);
    g.fillRect(x0+1,y0+1,(2*Cinta.VECINDAD+1)*H-1,H-1);
    g.setColor(Color.black);

    for(i=x0,j=1;j<=2*Cinta.VECINDAD+1;i+=H,j++)
      if(j!=Cinta.VECINDAD || j!=(Cinta.VECINDAD+1))
            g.drawLine(i,y0,i,y0+Cinta.H);
    
    
    //Agregado
    if(pageHead==pageBrowse){
        
        g.setColor(Color.red);
        //g.drawRect(x0+Cinta.VECINDAD*Cinta.H,y0,H,H);
        g.drawRect(x0+(getIndiceCabezal()%(2*Cinta.VECINDAD+1))*Cinta.H,y0,H,H);
        
        if(this.writeMode)
            g.setColor(Color.magenta);
        else
            g.setColor(Color.yellow);
    //g.fillRect(x0+Cinta.VECINDAD*Cinta.H+1,y0+1,H-1,H-1);
        g.fillRect(x0+(getIndiceCabezal()%(2*Cinta.VECINDAD+1))*Cinta.H+1,y0+1,H-1,H-1);
    }
    
    g.setColor(Color.black);
    g.setFont(Cinta.FONT_CB);
    
    for(i=delta;i<2*Cinta.VECINDAD+1+delta;i++){

      //if(i>=0 || i<=Cinta.MAX_i_cabezal){
        Integer integer = new Integer(i);
        if(caracteres.containsKey(integer))
            g.drawString(((Simbolo)caracteres.get(integer)).getNombre(),x0+(i-delta)*H+delta_x,y0+delta_y);
        else
            g.drawString("#",x0+(i-delta)*H+delta_x,y0+delta_y);
      //}
    }
  }
  
   
  public Integer indiceCabezal2Integer(){
      
        return new Integer(this.i_cabezal);
      
  }
  
  private Hashtable getCloneCaracteres(){
      
      try{
        return (Hashtable) this.caracteres.clone();
      }
      catch(Exception ex){ 
         System.out.println(ex.toString());
         return null;
      }
  }
  
  public void incrPageBrowse(){
       
      this.pageBrowse++;
  
  }
  
  public void decrPageBrowse(){
      
      if(this.pageBrowse==0) return;
      
      this.pageBrowse--;
  
  }
  
  /** Getter for property pageBrowse.
   * @return Value of property pageBrowse.
   */
  public int getPageBrowse() {
      return pageBrowse;
  }
  
  /** Setter for property pageBrowse.
   * @param pageBrowse New value of property pageBrowse.
   */
  public void setPageBrowse(int pageBrowse) {
      this.pageBrowse = pageBrowse;
  }
  
  
  public void findCabezal(){
      
       this.pageBrowse = i_cabezal/(2*Cinta.VECINDAD+1);
  }
  
}