/*
 * Variable.java
 *
 * Created on 3 de octubre de 2002, 03:53 AM
 */

/**
 *
 * @author  Administrador
 * @version 
 */
public class Variable implements Metavalor {
    
private int indexChar;
private Metavalor valor;
private String nombre;
private int referencias;
    /** Creates new Variable */
    public Variable(int newIndexChar) {
        
        indexChar = newIndexChar;
        nombre = Hellada.getChar(newIndexChar);
        valor = null;
    }
    
    public Variable(String newNombre) {
        
        nombre = newNombre;
        valor = null;
    }
    
    public void setIndexChar(int newIndexChar){
        
        indexChar = newIndexChar;
        nombre = Hellada.getChar(newIndexChar);
    }
    
    public int getIndexChar(){
        
        return indexChar;
    }
    
     public void setValor(Metavalor newValor){
         valor = null;
         valor = newValor;
    }
    
    public Metavalor getValor() throws NonSetException{
        
        if(this.isSet())
             return valor.getValor();
         else{
             throw new NonSetParException(); 
         }
    }
    
     public boolean equals(Metavalor valor) throws NonSetException{
        
        return this.getValor()==valor.getValor();
    }
    
     public boolean isSet(){
        
         return valor!=null;
    }
    
    public String getNombre() throws NonSetException{
        
        return nombre;
    }
    
    public void decrReferencias() {
        this.referencias--;
    }
    
    public void incrReferencias() {
        this.referencias++;
    }
    
    public boolean noReferencias() {
        return this.referencias==0;
    }
    
    public String getAsignacion() throws NonSetException {
        
        return getNombre()+"="+valor.getNombre();
    }
    
    public void setNombre(String newNombre){
         nombre = newNombre;
    }
    
}
