

//Title:        Proyecto Turing Visual

//Version:      

//Copyright:    Copyright (c) 1998

//Author:       Marco Antonio Mora Godoy

//Company:      Your Company

//Description:  No admires, CREA!!!!...

import java.awt.*;
import java.lang.*;

class Escritora extends Maquina {

  public Escritora(int x,int y,Cinta c,Maquina prev,Maquina prox,String newNombre){
    super(x,y,c,prev,prox);
    this.setNombre(newNombre);
  }
  
  Escritora(int x,int y,int c,Maquina prev,Maquina prox,String newNombre){
    super(x,y,c,prev,prox);
    this.setIconValue(JTV_1.MyRenderer.ICONO_ESCRITORA);
    this.setNombre(newNombre);
  }

  public void accion(){
    //cinta.escribir(caracter);
    proxima.accion();
  }
  
   public boolean accion(Cinta[] _arrayOfTapes,DiccionarioMetavalores dicMetavalores){
        
        Metavalor metavalor = dicMetavalores.getMetavalor(nombre);
        if(metavalor==null){
            if(CondicionEnlace.isNombreSimbolo(nombre))
                return _arrayOfTapes[this.getIndiceCinta()].escribir(Simbolo.getSimbolo(nombre));
            else
                return false;
        }
        else{
            try{
                Simbolo simbolo = (Simbolo)metavalor.getValor();
                if(simbolo==null)
                    return false;
                else
                    return _arrayOfTapes[this.getIndiceCinta()].escribir(simbolo);
            }
            catch(NonSetException ex){
                System.out.println("METAVALOR NO SETEADO");
                return false;
            }
        }
   }



  public void dibujar(Graphics g){

    if(Maquina.selectedMachine!=null && this==Maquina.selectedMachine)
        g.setColor(Color.magenta);
    else if(JTV_1.searchedMachine!=null && this==JTV_1.searchedMachine)
        g.setColor(Color.pink);
    else if(Maquina.playMachine!=null && this==Maquina.playMachine)
        g.setColor(Color.red);
    else if(CondicionEnlace.isNombreParametro(nombre))
        g.setColor(Parametro.VERDE);
    else
        g.setColor(Color.black);
    
    g.setFont(Maquina.FONT_TRI25);
    g.drawString(getNombre(),x0,y0);
    if(this.isInicial()) g.drawString(Maquina.SIMBOLO_INICIAL,x0-(int)Maquina.RECT_INICIAL.getWidth(),y0);
    if(Maquina.displayIndex){
        g.setFont(Maquina.FONT_TRP13);
        g.drawString("(" + (this.getIndiceCinta()+1) + ")",x0+Maquina.delta_x,y0-Maquina.delta_y);
    }
    super.dibujar(g);
  }
  
  
  public String getXML(){
      
      String xml = "";
      xml+="<escritora \n";
      xml+="    nombre=\""+Hellada.symbol2XML(this.nombre)+"\"\n";
      xml+="    id=\""+this.idMaquina+"\"\n";
      xml+="    id-previa=\""+(this.previa==null?"null":Integer.toString(this.previa.idMaquina))+"\"\n";
      xml+="    id-proxima=\""+(this.proxima==null?"null":Integer.toString(this.proxima.idMaquina))+"\"\n";
      xml+="    x=\""+this.x0+"\"\n";
      xml+="    y=\""+this.y0+"\"\n";
      xml+="    cinta=\""+this.getIndiceCinta()+"\"\n";
      xml+="    inicial=\""+this.isInicial()+"\"\n";
      xml+="/>\n\n";
      
      return xml;
  }  
  
}